/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.SignSubmitEvent;
import io.github.moulberry.notenoughupdates.mixins.AccessorGuiEditSign;
import io.github.moulberry.notenoughupdates.util.Calculator;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiEditSign;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SignCalculator {
    String lastSource = null;
    BigDecimal lastResult = null;
    Calculator.CalculatorException lastException = null;

    private boolean isEnabled() {
        return NotEnoughUpdates.INSTANCE.config.misc.calculationMode != 0;
    }

    @SubscribeEvent
    public void onSignDrawn(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!(event.gui instanceof GuiEditSign)) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        GuiEditSign guiEditSign = (GuiEditSign)event.gui;
        TileEntitySign tileSign = ((AccessorGuiEditSign)guiEditSign).getTileSign();
        if (!tileSign.field_145915_a[1].func_150260_c().equals("^^^^^^^^^^^^^^^") && !tileSign.field_145915_a[1].func_150260_c().equals("^^^^^^")) {
            return;
        }
        String source = tileSign.field_145915_a[0].func_150260_c();
        this.refresh(source);
        int calculationMode = NotEnoughUpdates.INSTANCE.config.misc.calculationMode;
        if (calculationMode == 1 && !source.startsWith("!")) {
            return;
        }
        Utils.drawStringCentered(this.getRenderedString(), (float)guiEditSign.field_146294_l / 2.0f, 58.0f, false, -2139062017);
    }

    @SubscribeEvent
    public void onSignSubmitted(SignSubmitEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (Objects.equals(event.lines[1], "^^^^^^^^^^^^^^^") || Objects.equals(event.lines[1], "^^^^^^")) {
            this.refresh(event.lines[0]);
            if (this.lastResult != null) {
                event.lines[0] = this.lastResult.toPlainString();
            }
        }
    }

    public String getRenderedString() {
        if (this.lastResult != null) {
            DecimalFormat formatter = new DecimalFormat("#,##0.##");
            String lr = formatter.format(this.lastResult);
            if (Minecraft.func_71410_x().field_71466_p.func_78256_a(lr) > 90) {
                return EnumChatFormatting.WHITE + this.lastSource + " " + EnumChatFormatting.YELLOW + "= " + EnumChatFormatting.RED + "Result too long";
            }
            return EnumChatFormatting.WHITE + this.lastSource + " " + EnumChatFormatting.YELLOW + "= " + EnumChatFormatting.GREEN + lr;
        }
        if (this.lastException != null) {
            return EnumChatFormatting.RED + this.lastException.getMessage();
        }
        return EnumChatFormatting.RED + "No calculation has been done.";
    }

    private void refresh(String source) {
        if (Objects.equals(source, this.lastSource)) {
            return;
        }
        this.lastSource = source;
        int calculationMode = NotEnoughUpdates.INSTANCE.config.misc.calculationMode;
        if (source.isEmpty() || calculationMode == 0 || calculationMode == 1 && !source.startsWith("!")) {
            this.lastResult = null;
            this.lastException = null;
            return;
        }
        try {
            this.lastResult = Calculator.calculate(calculationMode == 1 ? source.substring(1) : source);
            this.lastException = null;
        }
        catch (Calculator.CalculatorException ex) {
            this.lastException = ex;
            this.lastResult = null;
        }
    }
}

