/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscgui.minionhelper.util;

import io.github.moulberry.notenoughupdates.miscgui.minionhelper.ApiData;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.Minion;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.MinionHelperManager;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.requirements.CollectionRequirement;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.requirements.CustomRequirement;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.requirements.MinionRequirement;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.requirements.ReputationRequirement;
import io.github.moulberry.notenoughupdates.miscgui.minionhelper.requirements.SlayerRequirement;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MinionHelperRequirementsManager {
    private final MinionHelperManager manager;

    public MinionHelperRequirementsManager(MinionHelperManager manager) {
        this.manager = manager;
    }

    public List<MinionRequirement> getRequirements(Minion minion) {
        if (!minion.getRequirements().isEmpty()) {
            return minion.getRequirements();
        }
        Minion parent = minion.getParent();
        if (parent != null) {
            return this.getRequirements(parent);
        }
        return Collections.emptyList();
    }

    public boolean meetAllRequirements(Minion minion) {
        List<MinionRequirement> list = this.getRequirements(minion);
        for (MinionRequirement requirement : list) {
            if (this.meetRequirement(minion, requirement)) continue;
            return false;
        }
        Minion parent = minion.getParent();
        if (parent != null) {
            return this.meetAllRequirements(parent);
        }
        return true;
    }

    public boolean meetRequirement(Minion minion, MinionRequirement requirement) {
        ApiData apiData = this.manager.getApi().getApiData();
        if (apiData == null) {
            return false;
        }
        if (requirement instanceof CollectionRequirement) {
            if (apiData.isCollectionApiDisabled()) {
                return true;
            }
            CollectionRequirement collectionRequirement = (CollectionRequirement)requirement;
            String collection = collectionRequirement.getCollection();
            String internalName = this.manager.formatInternalName(collection);
            int need = collectionRequirement.getLevel();
            Map<String, Integer> highestCollectionTier = apiData.getHighestCollectionTier();
            if (highestCollectionTier.containsKey(internalName)) {
                int has = highestCollectionTier.get(internalName);
                return has >= need;
            }
        } else if (requirement instanceof SlayerRequirement) {
            SlayerRequirement slayerRequirement = (SlayerRequirement)requirement;
            String slayer = slayerRequirement.getSlayer();
            if (slayer.equals("eman")) {
                slayer = "enderman";
            }
            int need = slayerRequirement.getLevel();
            Map<String, Integer> slayerTiers = apiData.getSlayerTiers();
            if (slayerTiers.containsKey(slayer)) {
                return slayerTiers.get(slayer) >= need;
            }
        } else {
            if (requirement instanceof ReputationRequirement) {
                ReputationRequirement reputationRequirement = (ReputationRequirement)requirement;
                int need = reputationRequirement.getReputation();
                String reputationType = reputationRequirement.getReputationType();
                if (reputationType.equals("BARBARIAN")) {
                    return apiData.getBarbariansReputation() >= need;
                }
                if (reputationType.equals("MAGE")) {
                    return apiData.getMagesReputation() >= need;
                }
                Utils.addChatMessage("\u00a7c[NEU] Minion Helper: Unknown reputation type: '" + reputationType + "'");
                return false;
            }
            if (requirement instanceof CustomRequirement) {
                return minion.doesMeetRequirements();
            }
        }
        return false;
    }

    public void reloadRequirements() {
        for (Minion minion : this.manager.getAllMinions().values()) {
            minion.setMeetRequirements(this.meetAllRequirements(minion));
        }
    }
}

