/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.overlays;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpUtils;
import io.github.moulberry.notenoughupdates.overlays.TextOverlay;
import io.github.moulberry.notenoughupdates.overlays.TextOverlayStyle;
import io.github.moulberry.notenoughupdates.util.ItemResolutionQuery;
import io.github.moulberry.notenoughupdates.util.SidebarUtil;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.XPInformation;
import io.github.moulberry.notenoughupdates.util.hypixelapi.HypixelItemAPI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class FarmingSkillOverlay
extends TextOverlay {
    private static final NumberFormat format = NumberFormat.getIntegerInstance();
    private final HashMap<Integer, String> lineMap = new HashMap();
    private long lastUpdate = -1L;
    private long counterLast = -1L;
    private long counter = -1L;
    private int cultivatingLast = -1;
    private int cultivating = -1;
    private int cultivatingTier = -1;
    private String cultivatingTierAmount = "1";
    private int foraging = 0;
    private double coins = -1.0;
    private String lastItemHeld = "null";
    private int jacobPredictionLast = -1;
    private int jacobPrediction = -1;
    private boolean inJacobContest = false;
    private XPInformation.SkillInfo skillInfo = null;
    private XPInformation.SkillInfo skillInfoLast = null;
    private float lastTotalXp = -1.0f;
    private boolean isFarming = false;
    private final LinkedList<Float> xpGainQueue = new LinkedList();
    private float xpGainHourLast = -1.0f;
    private float xpGainHour = -1.0f;
    private int xpGainTimer = 0;
    public static final int CPS_WINDOW_SIZE = 302;
    private long[] cropsPerSecondValues = new long[302];
    private long[] cropsPerSecondTimeStamps = new long[302];
    private int cropsPerSecondCursor = -1;
    private float cropsPerSecondLast = 0.0f;
    private float cropsPerSecond = 0.0f;
    private float cpsResetTimer = 1.0f;
    private String skillType = "Farming";
    private static final Pattern CONTEST_AMOUNT_PATTERN = Pattern.compile(" (Collected|(BRONZE|SILVER|GOLD|PLATINUM|DIAMOND) with) (?<amount>[\\d,]+)");

    public FarmingSkillOverlay(Position position, Supplier<List<String>> dummyStrings, Supplier<TextOverlayStyle> styleSupplier) {
        super(position, dummyStrings, styleSupplier);
    }

    private float interpolate(float now, float last) {
        float interp = now;
        if (last >= 0.0f && last != now) {
            float factor = (float)(System.currentTimeMillis() - this.lastUpdate) / 1000.0f;
            factor = LerpUtils.clampZeroOne(factor);
            interp = last + (now - last) * factor;
        }
        return interp;
    }

    private int mod(int x, int y) {
        int mod = x % y;
        if (mod < 0) {
            mod += y;
        }
        return mod;
    }

    private void resetCropsPerSecond() {
        this.cropsPerSecondTimeStamps = new long[302];
        this.cropsPerSecondValues = new long[302];
        this.cropsPerSecond = 0.0f;
        this.cropsPerSecondLast = 0.0f;
    }

    private double getCoinsBz(String enchCropName, int numItemsForEnch) {
        JsonObject crop = NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo(enchCropName);
        if (crop != null && crop.has("curr_sell")) {
            return crop.get("curr_sell").getAsFloat() / (float)numItemsForEnch;
        }
        return 0.0;
    }

    private void gatherJacobData() {
        this.inJacobContest = false;
        if (FarmingSkillOverlay.isJacobTime()) {
            int timeLeftInContest = 1200 - (int)((System.currentTimeMillis() % 3600000L - 900000L) / 1000L);
            int cropsFarmed = -1;
            for (String line : SidebarUtil.readSidebarLines()) {
                Matcher matcher = CONTEST_AMOUNT_PATTERN.matcher(line);
                if (matcher.matches()) {
                    String amount = matcher.group("amount");
                    int lastComma = amount.lastIndexOf(44);
                    int extraZeros = lastComma != -1 ? 4 + lastComma - amount.length() : 0;
                    try {
                        this.inJacobContest = true;
                        cropsFarmed = Integer.parseInt(amount.replace(",", "")) * (int)Math.pow(10.0, extraZeros);
                    }
                    catch (NumberFormatException e2) {
                        e2.printStackTrace();
                    }
                }
                this.jacobPrediction = (int)((float)cropsFarmed + this.cropsPerSecond * (float)timeLeftInContest);
            }
        } else {
            this.jacobPrediction = -1;
            this.jacobPredictionLast = -1;
        }
    }

    private static boolean isJacobTime() {
        long now = System.currentTimeMillis();
        return now % 3600000L >= 900000L && now % 3600000L <= 0x200B20L;
    }

    @Override
    public boolean isEnabled() {
        return NotEnoughUpdates.INSTANCE.config.skillOverlays.farmingOverlay;
    }

    @Override
    public void update() {
        if (!this.isEnabled()) {
            this.counter = -1L;
            this.overlayStrings = null;
            this.resetCropsPerSecond();
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
        this.counterLast = this.counter;
        this.cultivatingLast = this.cultivating;
        this.xpGainHourLast = this.xpGainHour;
        this.counter = -1L;
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        this.updateCounter(stack);
        this.updateCropsPerSecond();
        String internalName = new ItemResolutionQuery(NotEnoughUpdates.INSTANCE.manager).withItemStack(stack).resolveInternalName();
        if (internalName != null) {
            this.updateSkillType(internalName);
        }
        this.updateSkillInfo();
        this.overlayStrings = this.counter != -1L ? new ArrayList() : null;
        this.gatherJacobData();
    }

    private void updateSkillType(String internalName) {
        this.skillType = "Farming";
        this.foraging = 0;
        boolean useBZPrice = NotEnoughUpdates.INSTANCE.config.skillOverlays.useBZPrice;
        if (internalName.equals("TREECAPITATOR_AXE") || internalName.equalsIgnoreCase("JUNGLE_AXE")) {
            this.skillType = "Foraging";
            this.foraging = 1;
            this.coins = 2.0;
        } else if (internalName.equals("FUNGI_CUTTER")) {
            if (useBZPrice) {
                this.coins = (this.getCoinsBz("ENCHANTED_RED_MUSHROOM", 160) + this.getCoinsBz("ENCHANTED_BROWN_MUSHROOM", 160)) / 2.0;
            } else {
                Double red = HypixelItemAPI.getNPCSellPrice("ENCHANTED_RED_MUSHROOM");
                Double brown = HypixelItemAPI.getNPCSellPrice("ENCHANTED_BROWN_MUSHROOM");
                this.coins = red == null || brown == null ? 0.0 : (red / 160.0 + brown / 160.0) / 2.0;
            }
        } else {
            this.coins = 0.0;
            for (CropType crop : CropType.values()) {
                if (!internalName.startsWith(crop.toolName)) continue;
                Double npcSellPrice = HypixelItemAPI.getNPCSellPrice(crop.item);
                if (npcSellPrice == null) {
                    npcSellPrice = 0.0;
                }
                this.coins = useBZPrice ? this.getCoinsBz(crop.item, crop.enchSize) : npcSellPrice / (double)crop.enchSize;
            }
        }
    }

    private void updateSkillInfo() {
        this.skillInfoLast = this.skillInfo;
        List<Integer> s = NotEnoughUpdates.INSTANCE.config.skillOverlays.farmingText;
        this.skillInfo = XPInformation.getInstance().getSkillInfo(this.skillType, s.contains(2) || s.contains(3) || s.contains(4) || s.contains(5) || s.contains(7));
        if (this.skillInfo != null) {
            float totalXp = (float)this.skillInfo.totalXp;
            if (this.lastTotalXp > 0.0f) {
                float delta = totalXp - this.lastTotalXp;
                if (delta > 0.0f && delta < 1000.0f) {
                    this.xpGainTimer = NotEnoughUpdates.INSTANCE.config.skillOverlays.farmingPauseTimer;
                    this.xpGainQueue.add(0, Float.valueOf(delta));
                    while (this.xpGainQueue.size() > 30) {
                        this.xpGainQueue.removeLast();
                    }
                    float totalGain = 0.0f;
                    Iterator iterator = this.xpGainQueue.iterator();
                    while (iterator.hasNext()) {
                        float f = ((Float)iterator.next()).floatValue();
                        totalGain += f;
                    }
                    this.xpGainHour = totalGain * 3600.0f / (float)this.xpGainQueue.size();
                    this.isFarming = true;
                } else if (this.xpGainTimer > 0) {
                    --this.xpGainTimer;
                    this.xpGainQueue.add(0, Float.valueOf(0.0f));
                    while (this.xpGainQueue.size() > 30) {
                        this.xpGainQueue.removeLast();
                    }
                    float totalGain = 0.0f;
                    Iterator iterator = this.xpGainQueue.iterator();
                    while (iterator.hasNext()) {
                        float f = ((Float)iterator.next()).floatValue();
                        totalGain += f;
                    }
                    this.xpGainHour = totalGain * 3600.0f / (float)this.xpGainQueue.size();
                    this.isFarming = true;
                } else if (delta <= 0.0f) {
                    this.isFarming = false;
                }
            }
            this.lastTotalXp = totalXp;
        }
    }

    private void updateCounter(ItemStack stack) {
        NBTTagCompound tag;
        if (stack != null && stack.func_77942_o() && (tag = stack.func_77978_p()).func_150297_b("ExtraAttributes", 10)) {
            NBTTagCompound ea = tag.func_74775_l("ExtraAttributes");
            if (ea.func_150297_b("mined_crops", 99)) {
                this.counter = ea.func_74763_f("mined_crops");
                this.cultivating = ea.func_74762_e("farmed_cultivating");
            } else if (ea.func_150297_b("farmed_cultivating", 99)) {
                this.counter = ea.func_74763_f("farmed_cultivating");
                this.cultivating = ea.func_74762_e("farmed_cultivating");
            }
        }
        if (this.cultivating < 1000) {
            this.cultivatingTier = 1;
            this.cultivatingTierAmount = "1,000";
        } else if (this.cultivating < 5000) {
            this.cultivatingTier = 2;
            this.cultivatingTierAmount = "5,000";
        } else if (this.cultivating < 25000) {
            this.cultivatingTier = 3;
            this.cultivatingTierAmount = "25,000";
        } else if (this.cultivating < 100000) {
            this.cultivatingTier = 4;
            this.cultivatingTierAmount = "100,000";
        } else if (this.cultivating < 300000) {
            this.cultivatingTier = 5;
            this.cultivatingTierAmount = "300,000";
        } else if (this.cultivating < 1500000) {
            this.cultivatingTier = 6;
            this.cultivatingTierAmount = "1,500,000";
        } else if (this.cultivating < 5000000) {
            this.cultivatingTier = 7;
            this.cultivatingTierAmount = "5,000,000";
        } else if (this.cultivating < 20000000) {
            this.cultivatingTier = 8;
            this.cultivatingTierAmount = "20,000,000";
        } else if (this.cultivating < 100000000) {
            this.cultivatingTier = 9;
            this.cultivatingTierAmount = "100,000,000";
        } else {
            this.cultivatingTier = 10;
            this.cultivatingTierAmount = "Maxed";
        }
    }

    private void updateCropsPerSecond() {
        String currentItemHeld;
        this.cropsPerSecondTimeStamps[++this.cropsPerSecondCursor % 302] = System.currentTimeMillis();
        this.cropsPerSecondValues[this.cropsPerSecondCursor % 302] = this.counter;
        long current = this.cropsPerSecondValues[this.cropsPerSecondCursor % 302];
        int timeFrame = Math.min(NotEnoughUpdates.INSTANCE.config.skillOverlays.farmingCropsPerSecondTimeFrame, 302);
        int searchIndex = this.mod(this.cropsPerSecondCursor - timeFrame, 302);
        while (this.cropsPerSecondValues[searchIndex] == this.cropsPerSecondValues[this.mod(searchIndex - 1, 302)] && this.mod(searchIndex, 302) != this.mod(this.cropsPerSecondCursor, 302)) {
            ++searchIndex;
            searchIndex %= 302;
        }
        float newCropsPerSecond = current - this.cropsPerSecondValues[searchIndex];
        float timePassed = this.cropsPerSecondTimeStamps[this.cropsPerSecondCursor % 302] - this.cropsPerSecondTimeStamps[searchIndex];
        if (Float.isNaN(newCropsPerSecond /= (timePassed /= 1000.0f))) {
            newCropsPerSecond = 0.0f;
        }
        this.cropsPerSecondLast = this.cropsPerSecond;
        this.cropsPerSecond = newCropsPerSecond;
        this.cpsResetTimer = this.counter == this.counterLast ? (this.cpsResetTimer += 1.0f) : 1.0f;
        String string = currentItemHeld = NEUManager.getUUIDForItem(Minecraft.func_71410_x().field_71439_g.func_70694_bm()) == null ? "null" : NEUManager.getUUIDForItem(Minecraft.func_71410_x().field_71439_g.func_70694_bm());
        if (!this.lastItemHeld.equals(currentItemHeld)) {
            this.lastItemHeld = currentItemHeld;
            this.resetCropsPerSecond();
        } else if (this.cpsResetTimer > (float)NotEnoughUpdates.INSTANCE.config.skillOverlays.farmingResetCPS) {
            this.resetCropsPerSecond();
        }
    }

    @Override
    public void updateFrequent() {
        super.updateFrequent();
        if (this.counter < 0L) {
            this.overlayStrings = null;
        } else {
            this.lineMap.clear();
            this.overlayStrings = new ArrayList();
            if ((long)this.cultivating != this.counter) {
                this.renderCounter();
            }
            if (this.counter >= 0L) {
                this.renderCropsPerSecond();
                if (this.coins > 0.0) {
                    this.renderCoins();
                }
            }
            this.renderCultivating();
            this.renderJacob();
            this.renderLevelAndXP();
            this.renderYawPitch();
            for (int strIndex : NotEnoughUpdates.INSTANCE.config.skillOverlays.farmingText) {
                if (this.lineMap.get(strIndex) == null) continue;
                this.overlayStrings.add(this.lineMap.get(strIndex));
            }
            if (this.overlayStrings != null && this.overlayStrings.isEmpty()) {
                this.overlayStrings = null;
            }
        }
    }

    private void renderCounter() {
        int counterInterp = (int)this.interpolate(this.counter, this.counterLast);
        this.lineMap.put(0, EnumChatFormatting.AQUA + "Counter: " + EnumChatFormatting.YELLOW + format.format(counterInterp));
    }

    private void renderCoins() {
        float coinsMultiplier = 0.0f;
        String unit = null;
        switch (NotEnoughUpdates.INSTANCE.config.skillOverlays.farmingCoinRateUnit) {
            case 0: {
                coinsMultiplier = 1.0f;
                unit = "/s";
                break;
            }
            case 1: {
                coinsMultiplier = 60.0f;
                unit = "/m";
                break;
            }
            case 2: {
                coinsMultiplier = 3600.0f;
                unit = "/h";
            }
        }
        if (this.cropsPerSecondLast == this.cropsPerSecond && this.cropsPerSecond <= 0.0f) {
            this.lineMap.put(10, EnumChatFormatting.AQUA + "Coins" + unit + ": " + EnumChatFormatting.YELLOW + "N/A");
        } else {
            float cropsPerSecond = this.cropsPerSecondLast != 0.0f ? this.interpolate(this.cropsPerSecond, this.cropsPerSecondLast) : this.cropsPerSecond;
            float cropsPerUnit = cropsPerSecond * coinsMultiplier;
            this.lineMap.put(10, EnumChatFormatting.AQUA + "Coins" + unit + ": " + EnumChatFormatting.YELLOW + String.format("%,.0f", (double)cropsPerUnit * this.coins));
        }
    }

    private void renderCultivating() {
        int counterInterp;
        if (this.cultivatingTier <= 9 && this.cultivating > 0) {
            counterInterp = (int)this.interpolate(this.cultivating, this.cultivatingLast);
            this.lineMap.put(9, EnumChatFormatting.AQUA + "Cultivating: " + EnumChatFormatting.YELLOW + format.format(counterInterp) + "/" + this.cultivatingTierAmount);
        }
        if (this.cultivatingTier == 10) {
            counterInterp = (int)this.interpolate(this.cultivating, this.cultivatingLast);
            this.lineMap.put(9, EnumChatFormatting.AQUA + "Cultivating: " + EnumChatFormatting.YELLOW + format.format(counterInterp));
        }
    }

    private void renderJacob() {
        if (FarmingSkillOverlay.isJacobTime() && this.inJacobContest) {
            if (this.jacobPredictionLast == this.jacobPrediction && this.jacobPrediction <= 0) {
                this.lineMap.put(11, EnumChatFormatting.AQUA + "Contest Estimate: " + EnumChatFormatting.YELLOW + "N/A");
            } else {
                float predInterp = this.interpolate(this.jacobPrediction, this.jacobPredictionLast);
                this.lineMap.put(11, EnumChatFormatting.AQUA + "Contest Estimate: " + EnumChatFormatting.YELLOW + String.format("%,.0f", Float.valueOf(predInterp)));
            }
        }
    }

    private void renderLevelAndXP() {
        float xpInterp = this.xpGainHour;
        if (this.xpGainHourLast == this.xpGainHour && this.xpGainHour <= 0.0f) {
            this.lineMap.put(5, EnumChatFormatting.AQUA + "XP/h: " + EnumChatFormatting.YELLOW + "N/A");
        } else {
            xpInterp = this.interpolate(this.xpGainHour, this.xpGainHourLast);
            this.lineMap.put(5, EnumChatFormatting.AQUA + "XP/h: " + EnumChatFormatting.YELLOW + format.format(xpInterp) + (this.isFarming ? "" : EnumChatFormatting.RED + " (PAUSED)"));
        }
        if (this.skillInfo != null && this.skillInfo.level < 60) {
            StringBuilder levelStr = new StringBuilder(EnumChatFormatting.AQUA + this.skillType + ": ");
            levelStr.append(EnumChatFormatting.YELLOW).append(this.skillInfo.level).append(EnumChatFormatting.GRAY).append(" [");
            float progress = (float)(this.skillInfo.currentXp / this.skillInfo.currentXpMax);
            if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                progress = this.interpolate(progress, (float)(this.skillInfoLast.currentXp / this.skillInfoLast.currentXpMax));
            }
            float lines = 25.0f;
            int i = 0;
            while ((float)i < lines) {
                if ((float)i / lines < progress) {
                    levelStr.append(EnumChatFormatting.YELLOW);
                } else {
                    levelStr.append(EnumChatFormatting.DARK_GRAY);
                }
                levelStr.append('|');
                ++i;
            }
            levelStr.append(EnumChatFormatting.GRAY).append("] ").append(EnumChatFormatting.YELLOW).append((int)(progress * 100.0f)).append("%");
            int current = (int)this.skillInfo.currentXp;
            if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                current = (int)this.interpolate(current, (float)this.skillInfoLast.currentXp);
            }
            int remaining = (int)(this.skillInfo.currentXpMax - this.skillInfo.currentXp);
            if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                remaining = (int)this.interpolate(remaining, (int)(this.skillInfoLast.currentXpMax - this.skillInfoLast.currentXp));
            }
            this.lineMap.put(2, levelStr.toString());
            this.lineMap.put(3, EnumChatFormatting.AQUA + "Current XP: " + EnumChatFormatting.YELLOW + format.format(current));
            if (remaining < 0) {
                this.lineMap.put(4, EnumChatFormatting.AQUA + "Remaining XP: " + EnumChatFormatting.YELLOW + "MAXED!");
                this.lineMap.put(7, EnumChatFormatting.AQUA + "ETA: " + EnumChatFormatting.YELLOW + "MAXED!");
            } else {
                this.lineMap.put(4, EnumChatFormatting.AQUA + "Remaining XP: " + EnumChatFormatting.YELLOW + format.format(remaining));
                if (this.xpGainHour < 1000.0f) {
                    this.lineMap.put(7, EnumChatFormatting.AQUA + "ETA: " + EnumChatFormatting.YELLOW + "N/A");
                } else {
                    this.lineMap.put(7, EnumChatFormatting.AQUA + "ETA: " + EnumChatFormatting.YELLOW + Utils.prettyTime((long)remaining * 1000L * 60L * 60L / (long)xpInterp));
                }
            }
        }
        if (this.skillInfo != null && this.skillInfo.level == 60) {
            int current = (int)this.skillInfo.currentXp;
            if (this.skillInfoLast != null && this.skillInfo.currentXpMax == this.skillInfoLast.currentXpMax) {
                current = (int)this.interpolate(current, (float)this.skillInfoLast.currentXp);
            }
            if (this.foraging == 0) {
                this.lineMap.put(2, EnumChatFormatting.AQUA + "Farming: " + EnumChatFormatting.YELLOW + "60 " + EnumChatFormatting.RED + "(Maxed)");
            } else {
                this.lineMap.put(2, EnumChatFormatting.AQUA + "Foraging: " + EnumChatFormatting.YELLOW + "50 " + EnumChatFormatting.RED + "(Maxed)");
            }
            this.lineMap.put(3, EnumChatFormatting.AQUA + "Current XP: " + EnumChatFormatting.YELLOW + format.format(current));
        }
    }

    private void renderYawPitch() {
        float yaw = Minecraft.func_71410_x().field_71439_g.field_70759_as;
        float pitch = Minecraft.func_71410_x().field_71439_g.field_70125_A;
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw > 180.0f) {
            yaw -= 360.0f;
        }
        if ((pitch %= 360.0f) < 0.0f) {
            pitch += 360.0f;
        }
        if (pitch > 180.0f) {
            pitch -= 360.0f;
        }
        this.lineMap.put(6, EnumChatFormatting.AQUA + "Yaw: " + EnumChatFormatting.YELLOW + String.format("%.2f\u00b0", Float.valueOf(yaw)));
        this.lineMap.put(8, EnumChatFormatting.AQUA + "Pitch: " + EnumChatFormatting.YELLOW + String.format("%.2f\u00b0", Float.valueOf(pitch)));
    }

    private void renderCropsPerSecond() {
        float cropsMultiplier = 0.0f;
        String unit = null;
        switch (NotEnoughUpdates.INSTANCE.config.skillOverlays.farmingCropRateUnit) {
            case 0: {
                cropsMultiplier = 1.0f;
                unit = "/s";
                break;
            }
            case 1: {
                cropsMultiplier = 60.0f;
                unit = "/m";
                break;
            }
            case 2: {
                cropsMultiplier = 3600.0f;
                unit = "/h";
            }
        }
        if (this.cropsPerSecondLast == this.cropsPerSecond && this.cropsPerSecond <= 0.0f) {
            this.lineMap.put(1, EnumChatFormatting.AQUA + (this.foraging == 1 ? "Logs" + unit + ": " : "Crops" + unit + ": ") + EnumChatFormatting.YELLOW + "N/A");
        } else {
            float cropsPerSecond = this.cropsPerSecondLast != 0.0f ? this.interpolate(this.cropsPerSecond, this.cropsPerSecondLast) : this.cropsPerSecond;
            float cropsPerUnit = cropsPerSecond * cropsMultiplier;
            this.lineMap.put(1, EnumChatFormatting.AQUA + (this.foraging == 1 ? "Logs" + unit + ": " : "Crops" + unit + ": ") + EnumChatFormatting.YELLOW + String.format("%,.0f", Float.valueOf(cropsPerUnit)));
        }
    }

    private static enum CropType {
        WHEAT("THEORETICAL_HOE_WHEAT", "ENCHANTED_HAY_BLOCK", 1296),
        NETHER_WART("THEORETICAL_HOE_WARTS", "ENCHANTED_NETHER_STALK", 160),
        SUGAR_CANE("THEORETICAL_HOE_CANE", "ENCHANTED_SUGAR", 160),
        CARROT("THEORETICAL_HOE_CARROT", "ENCHANTED_CARROT", 160),
        POTATO("THEORETICAL_HOE_POTATO", "ENCHANTED_POTATO", 160),
        COCOA_BEANS("COCO_CHOPPER", "ENCHANTED_COCOA", 160),
        PUMPKIN("PUMPKIN_DICER", "ENCHANTED_PUMPKIN", 160),
        MELON("MELON_DICER", "ENCHANTED_MELON", 160),
        CACTUS("CACTUS_KNIFE", "ENCHANTED_CACTUS_GREEN", 160);

        private final String toolName;
        private final String item;
        private final int enchSize;

        private CropType(String toolName, String item, int enchSize) {
            this.toolName = toolName;
            this.item = item;
            this.enchSize = enchSize;
        }
    }
}

