/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.Panorama;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewerUtils;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.level.LevelPage;
import io.github.moulberry.notenoughupdates.profileviewer.weight.lily.LilyWeight;
import io.github.moulberry.notenoughupdates.profileviewer.weight.senither.SenitherWeight;
import io.github.moulberry.notenoughupdates.profileviewer.weight.weight.Weight;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.PronounDB;
import io.github.moulberry.notenoughupdates.util.Rectangle;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.Color;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class BasicPage
extends GuiProfileViewerPage {
    private static final ResourceLocation pv_basic = new ResourceLocation("notenoughupdates:pv_basic.png");
    public static final ItemStack skull = Utils.createSkull("egirlefe", "152de44a-43a3-46e1-badc-66cca2793471", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODdkODg1YjMyYjBkZDJkNmI3ZjFiNTgyYTM0MTg2ZjhhNTM3M2M0NjU4OWEyNzM0MjMxMzJiNDQ4YjgwMzQ2MiJ9fX0=");
    private static final LinkedHashMap<String, ItemStack> pageModeIcon = new LinkedHashMap<String, ItemStack>(){
        {
            this.put("first_page", Utils.editItemStackInfo(new ItemStack(Items.field_151121_aF), EnumChatFormatting.GRAY + "Home", true, new String[0]));
            this.put("second_page", Utils.editItemStackInfo(skull, EnumChatFormatting.GRAY + "Level", true, new String[0]));
        }
    };
    private static final ExecutorService profileLoader = Executors.newFixedThreadPool(1);
    public EntityOtherPlayerMP entityPlayer = null;
    private ResourceLocation playerLocationSkin = null;
    private final GuiProfileViewer guiProfileViewer;
    private final String[] medalNames = new String[]{"\u00a7cBronze", "\u00a7fSilver", "\u00a76Gold"};
    private ResourceLocation playerLocationCape = null;
    private String skinType = null;
    private boolean loadingProfile = false;
    private int backgroundClickedX = -1;
    private final LevelPage levelPage;
    private boolean clickedLoadStatusButton = false;
    private String bingoRarity = "\u00a77";

    public BasicPage(GuiProfileViewer instance) {
        super(instance);
        this.guiProfileViewer = instance;
        this.levelPage = new LevelPage(this.guiProfileViewer, this);
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        Object lbPosStr;
        int i;
        Optional pronounChoice;
        JsonObject status2;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        SkyblockProfiles profile = GuiProfileViewer.getProfile();
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        if (GuiProfileViewer.onSecondPage) {
            this.levelPage.drawPage(mouseX, mouseY, partialTicks);
            return;
        }
        String location = null;
        JsonObject jsonObject = status2 = this.clickedLoadStatusButton ? profile.getPlayerStatus() : null;
        if (status2 != null && status2.has("mode")) {
            location = status2.get("mode").getAsString();
        }
        int extraRotation = 0;
        if (Mouse.isButtonDown((int)0) || Mouse.isButtonDown((int)1)) {
            if (this.backgroundClickedX == -1 && mouseX > guiLeft + 23 && mouseX < guiLeft + 23 + 81 && mouseY > guiTop + 44 && mouseY < guiTop + 44 + 108) {
                this.backgroundClickedX = mouseX;
            }
        } else if (this.backgroundClickedX != -1) {
            this.getInstance().backgroundRotation += (float)(mouseX - this.backgroundClickedX);
            this.backgroundClickedX = -1;
        }
        if (this.backgroundClickedX == -1) {
            this.getInstance().backgroundRotation += (float)(this.getInstance().currentTime - this.getInstance().lastTime) / 400.0f;
        } else {
            extraRotation = mouseX - this.backgroundClickedX;
        }
        this.getInstance().backgroundRotation %= 360.0f;
        String panoramaIdentifier = "day";
        if (SBInfo.getInstance().currentTimeDate != null && (SBInfo.getInstance().currentTimeDate.getHours() <= 6 || SBInfo.getInstance().currentTimeDate.getHours() >= 20)) {
            panoramaIdentifier = "night";
        }
        Panorama.drawPanorama(-this.getInstance().backgroundRotation - (float)extraRotation, guiLeft + 23, guiTop + 44, 81, 108, 0.37f, 0.8f, Panorama.getPanoramasForLocation(location == null ? "unknown" : location, panoramaIdentifier));
        if (Utils.isWithinRect(mouseX, mouseY, guiLeft + 23, guiTop + 44, 81, 108) && (pronounChoice = GuiProfileViewer.pronouns.peekValue().flatMap(it -> it)).isPresent()) {
            PronounDB.PronounChoice pronouns2 = (PronounDB.PronounChoice)pronounChoice.get();
            this.getInstance().tooltipToDisplay = Collections.singletonList(pronouns2.render());
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pv_basic);
        Utils.drawTexturedRect(guiLeft, guiTop, this.getInstance().sizeX, this.getInstance().sizeY, 9728);
        String profileName = GuiProfileViewer.getProfileName();
        SkyblockProfiles.SkyblockProfile selectedProfile = this.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        if (this.entityPlayer != null && profile.getHypixelProfile() != null) {
            String playerName = null;
            if (profile.getHypixelProfile().has("prefix")) {
                playerName = Utils.getElementAsString(profile.getHypixelProfile().get("prefix"), "") + " " + this.entityPlayer.func_70005_c_();
            } else {
                JsonObject misc;
                String rank = Utils.getElementAsString(profile.getHypixelProfile().get("rank"), "NORMAL");
                if (rank.equals("NORMAL") && (rank = Utils.getElementAsString(profile.getHypixelProfile().get("monthlyPackageRank"), "NONE")).equals("NONE")) {
                    rank = Utils.getElementAsString(profile.getHypixelProfile().get("newPackageRank"), "NONE");
                }
                EnumChatFormatting rankPlusColorECF = EnumChatFormatting.func_96300_b((String)Utils.getElementAsString(profile.getHypixelProfile().get("rankPlusColor"), "RED"));
                String rankPlusColor = EnumChatFormatting.RED.toString();
                if (rankPlusColorECF != null) {
                    rankPlusColor = rankPlusColorECF.toString();
                }
                if ((misc = Constants.MISC) != null && misc.has("ranks")) {
                    String rankName = Utils.getElementAsString(Utils.getElement(misc, "ranks." + rank + ".tag"), null);
                    String rankColor = Utils.getElementAsString(Utils.getElement(misc, "ranks." + rank + ".color"), "7");
                    String rankPlus = Utils.getElementAsString(Utils.getElement(misc, "ranks." + rank + ".plus"), "");
                    String rankTagColor = Utils.getElementAsString(Utils.getElement(misc, "ranks." + rank + ".tagColor"), rankColor);
                    String name = this.entityPlayer.func_70005_c_();
                    if (misc.has("special_bois")) {
                        JsonArray special_bois = misc.get("special_bois").getAsJsonArray();
                        for (i = 0; i < special_bois.size(); ++i) {
                            if (!special_bois.get(i).getAsString().equals(profile.getUuid())) continue;
                            name = Utils.chromaString(name);
                            break;
                        }
                    }
                    playerName = EnumChatFormatting.GRAY + name;
                    if (rankName != null) {
                        String icon = selectedProfile.getGamemode() == null ? "" : this.getIcon(selectedProfile.getGamemode());
                        playerName = MessageFormat.format("\u00a7{0}[\u00a7{1}{2}{3}{4}\u00a7{5}] {6}", rankColor, rankTagColor, rankName, rankPlusColor, rankPlus, rankColor, name) + (icon.equals("") ? "" : " " + icon);
                    }
                }
            }
            if (playerName != null) {
                int rankPrefixLen = fr.func_78256_a(playerName);
                int halfRankPrefixLen = rankPrefixLen / 2;
                int x = guiLeft + 63;
                int y = guiTop + 54;
                GuiScreen.func_73734_a((int)(x - halfRankPrefixLen - 1), (int)(y - 1), (int)(x + halfRankPrefixLen + 1), (int)(y + 8), (int)new Color(0, 0, 0, 64).getRGB());
                fr.func_175065_a(playerName, (float)(x - halfRankPrefixLen), (float)y, 0, true);
            }
        }
        String stateStr = EnumChatFormatting.RED + "An error occurred";
        long networth = -2L;
        ArrayList<String> nwCategoryHover = new ArrayList<String>();
        if (NotEnoughUpdates.INSTANCE.config.profileViewer.useSoopyNetworth) {
            SkyblockProfiles.SoopyNetworth nwData = selectedProfile.getSoopyNetworth(() -> {});
            networth = nwData.getNetworth();
            if (networth == -1L) {
                stateStr = EnumChatFormatting.YELLOW + "Loading...";
            } else if (networth != -2L) {
                for (Map.Entry<String, Long> entry : nwData.getCategoryToTotal().entrySet()) {
                    nwCategoryHover.add(EnumChatFormatting.GREEN + WordUtils.capitalizeFully((String)entry.getKey().replace("_", " ")) + ": " + EnumChatFormatting.GOLD + StringUtils.formatNumber(entry.getValue()));
                }
                nwCategoryHover.add("");
            }
        }
        if (networth == -2L) {
            networth = selectedProfile.getNetworth();
        }
        if (networth > 0L) {
            int offset;
            int fontWidth = fr.func_78256_a("Net Worth: " + StringUtils.formatNumber(networth));
            int n = offset = fontWidth >= 117 ? 63 + (fontWidth - 117) : 63;
            if (fontWidth >= 117) {
                fr.func_175065_a(EnumChatFormatting.GREEN + "Net Worth: " + EnumChatFormatting.GOLD + StringUtils.formatNumber(networth), (float)(guiLeft + 8), (float)(guiTop + 38) - (float)fr.field_78288_b / 2.0f, 0, true);
            } else {
                Utils.drawStringCentered(EnumChatFormatting.GREEN + "Net Worth: " + EnumChatFormatting.GOLD + StringUtils.formatNumber(networth), guiLeft + 68, guiTop + 38, true, 0);
            }
            double networthInCookies = -1.0;
            if (NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo("BOOSTER_COOKIE") != null && NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo("BOOSTER_COOKIE").has("avg_buy")) {
                networthInCookies = (double)networth / NotEnoughUpdates.INSTANCE.manager.auctionManager.getBazaarInfo("BOOSTER_COOKIE").get("avg_buy").getAsDouble();
            }
            String networthIRLMoney = StringUtils.formatNumber(Math.round(networthInCookies * 325.0 / 675.0 * 4.99));
            if (mouseX > guiLeft + offset - fontWidth / 2 && mouseX < guiLeft + offset + fontWidth / 2 && mouseY > guiTop + 32 && mouseY < guiTop + 38 + fr.field_78288_b) {
                this.getInstance().tooltipToDisplay = new ArrayList<String>();
                this.getInstance().tooltipToDisplay.add(EnumChatFormatting.GREEN + "Net worth in IRL money: " + EnumChatFormatting.DARK_GREEN + "$" + EnumChatFormatting.GOLD + (networthInCookies >= 0.0 ? networthIRLMoney : EnumChatFormatting.RED + "ERROR"));
                if (NotEnoughUpdates.INSTANCE.config.profileViewer.useSoopyNetworth && profile.getSoopyNetworthLeaderboardPosition() >= 0L && profile.isProfileMaxSoopyWeight(profileName)) {
                    this.getInstance().tooltipToDisplay.add("");
                    lbPosStr = EnumChatFormatting.DARK_GREEN + "#" + EnumChatFormatting.GOLD + StringUtils.formatNumber(profile.getSoopyNetworthLeaderboardPosition());
                    this.getInstance().tooltipToDisplay.add((String)lbPosStr + EnumChatFormatting.GREEN + " on soopy's networth leaderboard!");
                }
                if (Keyboard.isKeyDown((int)42)) {
                    this.getInstance().tooltipToDisplay.addAll(nwCategoryHover);
                    this.getInstance().tooltipToDisplay.add(EnumChatFormatting.RED + "The IRL price is calculated using the current");
                    this.getInstance().tooltipToDisplay.add(EnumChatFormatting.RED + "price of booster cookies on bazaar and the price");
                    this.getInstance().tooltipToDisplay.add(EnumChatFormatting.RED + "for cookies using gems, then the price of gems");
                    this.getInstance().tooltipToDisplay.add(EnumChatFormatting.RED + "is where we get the amount of IRL money you");
                    this.getInstance().tooltipToDisplay.add(EnumChatFormatting.RED + "theoretically have on SkyBlock in net worth.");
                } else {
                    this.getInstance().tooltipToDisplay.add(EnumChatFormatting.GRAY + "[SHIFT for Info]");
                }
                this.getInstance().tooltipToDisplay.add("");
                this.getInstance().tooltipToDisplay.add(EnumChatFormatting.RED + "THIS IS IN NO WAY ENDORSING IRL TRADING!");
            }
        } else {
            int errFontWidth = fr.func_78256_a("Net Worth: " + stateStr);
            if (errFontWidth >= 117) {
                fr.func_175065_a(EnumChatFormatting.GREEN + "Net Worth: " + stateStr, (float)(guiLeft + 8), (float)(guiTop + 38) - (float)fr.field_78288_b / 2.0f, 0, true);
            } else {
                Utils.drawStringCentered(EnumChatFormatting.GREEN + "Net Worth: " + stateStr, guiLeft + 63, guiTop + 38, true, 0);
            }
        }
        if (status2 != null) {
            JsonElement onlineElement = Utils.getElement(status2, "online");
            boolean online = onlineElement != null && onlineElement.isJsonPrimitive() && onlineElement.getAsBoolean();
            String statusStr = online ? EnumChatFormatting.GREEN + "ONLINE" : EnumChatFormatting.RED + "OFFLINE";
            String locationStr = null;
            if (profile.getUuid().equals("20934ef9488c465180a78f861586b4cf")) {
                locationStr = "Ignoring DMs";
            } else if (profile.getUuid().equals("b876ec32e396476ba1158438d83c67d4")) {
                statusStr = EnumChatFormatting.LIGHT_PURPLE + "Long live Potato King";
                ItemStack potato_crown = NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("POTATO_CROWN"));
                potato_crown.func_77966_a(Enchantment.field_77347_r, 1656638942);
                Minecraft.func_71410_x().func_175599_af().func_175042_a(new ItemStack(Items.field_151174_bG), guiLeft + 35, guiTop + 160);
                Minecraft.func_71410_x().func_175599_af().func_175042_a(potato_crown, guiLeft + 50, guiTop + 162);
                Minecraft.func_71410_x().func_175599_af().func_175042_a(new ItemStack(Items.field_151174_bG), guiLeft + 63, guiTop + 160);
            } else if (online) {
                locationStr = NotEnoughUpdates.INSTANCE.navigation.getNameForAreaModeOrUnknown(location);
            }
            if (locationStr != null) {
                statusStr = statusStr + EnumChatFormatting.GRAY + " - " + EnumChatFormatting.GREEN + locationStr;
            }
            Utils.drawStringCentered(statusStr, guiLeft + 63, guiTop + 160, true, 0);
        } else {
            Rectangle buttonRect = new Rectangle(guiLeft + 24, guiTop + 155, 80, 12);
            RenderUtils.drawFloatingRectWithAlpha(buttonRect.getX(), buttonRect.getY(), buttonRect.getWidth(), buttonRect.getHeight(), 100, true);
            Utils.renderShadowedString(this.clickedLoadStatusButton ? EnumChatFormatting.AQUA + "Loading..." : EnumChatFormatting.WHITE + "Load Status", guiLeft + 63, guiTop + 157, 79);
            if (Mouse.getEventButtonState() && Utils.isWithinRect(mouseX, mouseY, buttonRect)) {
                this.clickedLoadStatusButton = true;
            }
        }
        if (this.entityPlayer == null) {
            if (!this.loadingProfile || ((ThreadPoolExecutor)profileLoader).getActiveCount() == 0) {
                this.loadingProfile = true;
                UUID playerUUID = UUID.fromString(this.niceUuid(profile.getUuid()));
                profileLoader.submit(() -> {
                    GameProfile fakeProfile = Minecraft.func_71410_x().func_152347_ac().fillProfileProperties(new GameProfile(playerUUID, "CoolGuy123"), false);
                    Minecraft.func_71410_x().func_152344_a(() -> {
                        this.entityPlayer = new EntityOtherPlayerMP((World)Minecraft.func_71410_x().field_71441_e, fakeProfile){

                            public ResourceLocation func_110306_p() {
                                return BasicPage.this.playerLocationSkin == null ? DefaultPlayerSkin.func_177334_a((UUID)this.func_110124_au()) : BasicPage.this.playerLocationSkin;
                            }

                            public ResourceLocation func_110303_q() {
                                return BasicPage.this.playerLocationCape;
                            }

                            public String func_175154_l() {
                                return BasicPage.this.skinType == null ? DefaultPlayerSkin.func_177332_b((UUID)this.func_110124_au()) : BasicPage.this.skinType;
                            }
                        };
                        this.entityPlayer.func_174805_g(false);
                        this.entityPlayer.func_96094_a("");
                    });
                });
            }
        } else {
            this.entityPlayer.refreshDisplayName();
            byte b = 0;
            for (EnumPlayerModelParts part : EnumPlayerModelParts.values()) {
                b = (byte)(b | part.func_179327_a());
            }
            this.entityPlayer.func_70096_w().func_75692_b(10, (Object)b);
        }
        Map<String, ProfileViewer.Level> skyblockInfo = this.getSelectedProfile().getLevelingInfo();
        Map<String, JsonArray> inventoryInfo = this.getSelectedProfile().getInventoryInfo();
        if (this.entityPlayer != null) {
            if (this.backgroundClickedX != -1 && Mouse.isButtonDown((int)1)) {
                Arrays.fill(this.entityPlayer.field_71071_by.field_70460_b, null);
            } else if (inventoryInfo != null && inventoryInfo.containsKey("inv_armor")) {
                JsonArray items2 = inventoryInfo.get("inv_armor");
                if (items2 != null && items2.size() == 4) {
                    for (int i2 = 0; i2 < this.entityPlayer.field_71071_by.field_70460_b.length; ++i2) {
                        JsonElement itemElement = items2.get(i2);
                        if (itemElement == null || !itemElement.isJsonObject()) continue;
                        this.entityPlayer.field_71071_by.field_70460_b[i2] = NotEnoughUpdates.INSTANCE.manager.jsonToStack(itemElement.getAsJsonObject(), false);
                    }
                }
            } else {
                Arrays.fill(this.entityPlayer.field_71071_by.field_70460_b, null);
            }
            if (this.entityPlayer.func_110124_au().toString().equals("ae6193ab-494a-4719-b6e7-d50392c8f012")) {
                this.entityPlayer.field_71071_by.field_70460_b[3] = NotEnoughUpdates.INSTANCE.manager.jsonToStack(NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("SMALL_BACKPACK"));
            }
        }
        if (this.entityPlayer != null && this.playerLocationSkin == null) {
            try {
                Minecraft.func_71410_x().func_152342_ad().func_152790_a(this.entityPlayer.func_146103_bH(), (type2, location1, profileTexture) -> {
                    switch (type2) {
                        case SKIN: {
                            this.playerLocationSkin = location1;
                            this.skinType = profileTexture.getMetadata("model");
                            if (this.skinType != null) break;
                            this.skinType = "default";
                            break;
                        }
                        case CAPE: {
                            this.playerLocationCape = location1;
                        }
                    }
                }, false);
            }
            catch (Exception items2) {
                // empty catch block
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SkyblockProfiles.SkyblockProfile currentProfile = profile.getProfile(profileName);
        JsonObject petsInfo = currentProfile.getPetsInfo();
        if (petsInfo != null) {
            JsonElement activePetElement;
            JsonArray pets;
            if (currentProfile.getGamemode() != null && currentProfile.getGamemode().equals("bingo") && (pets = petsInfo.get("pets").getAsJsonArray()) != null) {
                JsonElement pet;
                JsonObject petJsonObject;
                lbPosStr = pets.iterator();
                while (lbPosStr.hasNext() && (petJsonObject = (pet = lbPosStr.next()).getAsJsonObject()).get("type") != null) {
                    if (petJsonObject.get("type").getAsString().equals("BINGO")) {
                        String tier;
                        if (petJsonObject.get("tier") == null) break;
                        switch (tier = petJsonObject.get("tier").getAsString()) {
                            case "COMMON": {
                                this.bingoRarity = "\u00a77";
                                break;
                            }
                            case "UNCOMMON": {
                                this.bingoRarity = "\u00a7a";
                                break;
                            }
                            case "RARE": {
                                this.bingoRarity = "\u00a79";
                                break;
                            }
                            case "EPIC": {
                                this.bingoRarity = "\u00a75";
                                break;
                            }
                            case "LEGENDARY": {
                                this.bingoRarity = "\u00a76";
                                break;
                            }
                            case "MYTHIC": {
                                this.bingoRarity = "\u00a7d";
                            }
                        }
                        break;
                    }
                    this.bingoRarity = "\u00a77";
                }
            }
            if ((activePetElement = petsInfo.get("active_pet")) != null && activePetElement.isJsonObject()) {
                JsonObject activePet = activePetElement.getAsJsonObject();
                String type3 = activePet.get("type").getAsString();
                for (i = 0; i < 4; ++i) {
                    JsonObject item = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(type3 + ";" + i);
                    if (item == null) continue;
                    int x = guiLeft + 20;
                    float y = (float)(guiTop + 82) + 15.0f * (float)Math.sin((double)((float)(this.getInstance().currentTime - this.getInstance().startTime) / 800.0f) % (Math.PI * 2));
                    GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                    ItemStack stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(item, false);
                    NBTTagCompound stackTag = stack.func_77978_p() == null ? new NBTTagCompound() : stack.func_77978_p();
                    stackTag.func_82580_o("ExtraAttributes");
                    stack.func_77982_d(stackTag);
                    GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.0f);
                    GlStateManager.func_179126_j();
                    Utils.drawItemStack(stack, 0, 0);
                    GlStateManager.func_179152_a((float)0.6666667f, (float)0.6666667f, (float)1.0f);
                    GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
                    break;
                }
            }
        }
        if (this.entityPlayer != null) {
            this.drawEntityOnScreen(guiLeft + 63, guiTop + 128 + 7, 36, guiLeft + 63 - mouseX, guiTop + 129 - mouseY, (EntityLivingBase)this.entityPlayer);
        }
        int sbLevelX = guiLeft + 162;
        int sbLevelY = guiTop + 74;
        double skyblockLevel = currentProfile.getSkyblockLevel();
        EnumChatFormatting skyblockLevelColour = currentProfile.getSkyblockLevelColour();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)sbLevelX, (float)sbLevelY, (float)0.0f);
        GlStateManager.func_179152_a((float)1.5f, (float)1.5f, (float)1.0f);
        Utils.drawItemStack(skull, 0, 0);
        GlStateManager.func_179121_F();
        Utils.drawStringCenteredScaled(skyblockLevelColour.toString() + (int)skyblockLevel, sbLevelX + 9, sbLevelY - 12, true, 1.5f);
        float progress = (float)(skyblockLevel - (double)((long)skyblockLevel));
        this.getInstance().renderBar(sbLevelX - 30, sbLevelY + 30, 80.0f, progress);
        Utils.drawStringScaled(EnumChatFormatting.YELLOW.toString() + (int)(progress * 100.0f) + "/100", sbLevelX - 30, sbLevelY + 20, true, 0, 0.9f);
        if (mouseX >= guiLeft + 128 && mouseX <= guiLeft + 216 && mouseY >= guiTop + 49 && mouseY <= guiTop + 113 && Mouse.isButtonDown((int)0)) {
            GuiProfileViewer.onSecondPage = true;
        }
        if (skyblockInfo != null && selectedProfile.skillsApiEnabled()) {
            int position = 0;
            for (Map.Entry<String, ItemStack> entry : ProfileViewer.getSkillToSkillDisplayMap().entrySet()) {
                if (entry.getValue() == null || entry.getKey() == null) {
                    ++position;
                    continue;
                }
                int yPosition = position % 8;
                int xPosition = position / 8;
                String skillName = entry.getValue().func_82833_r();
                ProfileViewer.Level level = skyblockInfo.get(entry.getKey());
                int levelFloored = (int)Math.floor(level.level);
                int x = guiLeft + 237 + 86 * xPosition;
                int y = guiTop + 24 + 21 * yPosition;
                if (entry.getKey().equals("social")) {
                    --position;
                    x = guiLeft + 132;
                    y = guiTop + 124;
                }
                Utils.renderAlignedString(skillName, EnumChatFormatting.WHITE.toString() + levelFloored, x + 14, y - 4, 60);
                if (level.maxed) {
                    this.getInstance().renderGoldBar(x, y + 6, 80.0f);
                } else {
                    this.getInstance().renderBar(x, y + 6, 80.0f, level.level % 1.0f);
                }
                if (mouseX > x && mouseX < x + 80 && mouseY > y - 4 && mouseY < y + 13) {
                    String slayerNameLower;
                    List<String> tooltipToDisplay = this.getInstance().tooltipToDisplay = new ArrayList<String>();
                    tooltipToDisplay.add(skillName);
                    if (level.maxed) {
                        tooltipToDisplay.add(EnumChatFormatting.GRAY + "Progress: " + EnumChatFormatting.GOLD + "MAXED!");
                    } else {
                        int maxXp = (int)level.maxXpForLevel;
                        float currentXp = level.level % 1.0f * (float)maxXp;
                        String currentProgressPercentage = StringUtils.formatToTenths(Float.valueOf(currentXp / (float)maxXp * 100.0f));
                        this.getInstance().tooltipToDisplay.add(EnumChatFormatting.GRAY + "Progress: " + EnumChatFormatting.DARK_PURPLE + StringUtils.shortNumberFormat(Math.round(currentXp)) + "/" + StringUtils.shortNumberFormat(maxXp) + EnumChatFormatting.DARK_GRAY + " (" + currentProgressPercentage + "% to " + ((int)level.level + 1) + ")");
                    }
                    String totalXpS = StringUtils.formatNumber((long)level.totalXp);
                    tooltipToDisplay.add(EnumChatFormatting.GRAY + "Total XP: " + EnumChatFormatting.DARK_PURPLE + totalXpS + EnumChatFormatting.DARK_GRAY + " (" + StringUtils.formatToTenths(Float.valueOf(this.guiProfileViewer.getPercentage(entry.getKey().toLowerCase(Locale.ROOT), level))) + "% to " + level.maxLevel + ")");
                    if (entry.getKey().equals("farming")) {
                        int doubleDrops = Utils.getElementAsInt(Utils.getElement(selectedProfile.getProfileJson(), "jacobs_contest.perks.double_drops"), 0);
                        int peltCount = Utils.getElementAsInt(Utils.getElement(selectedProfile.getProfileJson(), "quests.trapper_quest.pelt_count"), 0);
                        if (doubleDrops == 15) {
                            tooltipToDisplay.add("\u00a77Double Drops: \u00a76" + doubleDrops * 2 + "%");
                        } else {
                            tooltipToDisplay.add("\u00a77Double Drops: \u00a75" + doubleDrops * 2 + "%");
                        }
                        tooltipToDisplay.add("\u00a77Pelts: \u00a7e" + peltCount);
                        JsonObject medals_inv = Utils.getElementOrDefault(selectedProfile.getProfileJson(), "jacobs_contest.medals_inv", new JsonObject()).getAsJsonObject();
                        tooltipToDisplay.add(" ");
                        for (String medalName : this.medalNames) {
                            String textWithoutFormattingCodes = EnumChatFormatting.func_110646_a((String)medalName.toLowerCase(Locale.ROOT));
                            if (medals_inv.has(textWithoutFormattingCodes)) {
                                int medalAmount = medals_inv.get(textWithoutFormattingCodes).getAsInt();
                                tooltipToDisplay.add(EnumChatFormatting.GRAY + WordUtils.capitalize((String)medalName) + ": " + EnumChatFormatting.WHITE + medalAmount);
                                continue;
                            }
                            tooltipToDisplay.add(EnumChatFormatting.GRAY + WordUtils.capitalize((String)medalName) + ": " + EnumChatFormatting.WHITE + "0");
                        }
                    }
                    if (Weight.SLAYER_NAMES.contains(slayerNameLower = entry.getKey().toLowerCase(Locale.ROOT))) {
                        JsonObject slayerToTier = Constants.LEVELING.getAsJsonObject("slayer_to_highest_tier");
                        if (slayerToTier == null) {
                            Utils.showOutdatedRepoNotification("leveling.json");
                            return;
                        }
                        int maxLevel = slayerToTier.get(slayerNameLower).getAsInt();
                        for (int i3 = 0; i3 < 5 && i3 < maxLevel; ++i3) {
                            float tier = Utils.getElementAsFloat(Utils.getElement(selectedProfile.getProfileJson(), "slayer.slayer_bosses." + slayerNameLower + ".boss_kills_tier_" + i3), 0.0f);
                            tooltipToDisplay.add(EnumChatFormatting.GRAY + "T" + (i3 + 1) + " Kills: " + EnumChatFormatting.RED + (int)tier);
                        }
                    }
                }
                GL11.glTranslatef((float)x, (float)((float)y - 6.0f), (float)0.0f);
                GL11.glScalef((float)0.7f, (float)0.7f, (float)1.0f);
                Utils.drawItemStackLinear(entry.getValue(), 0, 0);
                GL11.glScalef((float)1.4285715f, (float)1.4285715f, (float)1.0f);
                GL11.glTranslatef((float)(-x), (float)(-((float)y - 6.0f)), (float)0.0f);
                ++position;
            }
        } else {
            Utils.drawStringCentered(EnumChatFormatting.RED + "Skills API not enabled!", guiLeft + 322, guiTop + 101, true, 0);
        }
        this.drawSideButtons(mouseX, mouseY);
        if (NotEnoughUpdates.INSTANCE.config.profileViewer.displayWeight) {
            this.renderWeight(mouseX, mouseY, selectedProfile);
        }
        selectedProfile.updateTamingLevel();
        selectedProfile.updateBeastMasterMultiplier();
    }

    private String getIcon(String gameModeType) {
        switch (gameModeType) {
            case "island": {
                return "\u00a7a\u2600";
            }
            case "bingo": {
                return this.bingoRarity + "\u24b7";
            }
            case "ironman": {
                return "\u00a77\u2672";
            }
        }
        return "";
    }

    @Override
    public void resetCache() {
        this.entityPlayer = null;
        this.playerLocationSkin = null;
        this.playerLocationCape = null;
        this.skinType = null;
    }

    private String niceUuid(String uuidStr) {
        if (uuidStr.length() != 32) {
            return uuidStr;
        }
        return uuidStr.substring(0, 8) + "-" + uuidStr.substring(8, 12) + "-" + uuidStr.substring(12, 16) + "-" + uuidStr.substring(16, 20) + "-" + uuidStr.substring(20, 32);
    }

    private void renderWeight(int mouseX, int mouseY, SkyblockProfiles.SkyblockProfile selectedProfile) {
        if (!selectedProfile.skillsApiEnabled()) {
            return;
        }
        Map<String, ProfileViewer.Level> skyblockInfo = selectedProfile.getLevelingInfo();
        if (skyblockInfo == null) {
            return;
        }
        SkyblockProfiles profile = GuiProfileViewer.getProfile();
        String profileName = GuiProfileViewer.getProfileName();
        if (Constants.WEIGHT == null || Utils.getElement(Constants.WEIGHT, "lily.skills.overall") == null || !Utils.getElement(Constants.WEIGHT, "lily.skills.overall").isJsonPrimitive()) {
            Utils.showOutdatedRepoNotification("weight.json");
            return;
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        SenitherWeight senitherWeight = new SenitherWeight(skyblockInfo);
        LilyWeight lilyWeight = new LilyWeight(skyblockInfo, selectedProfile.getProfileJson());
        long weight = -2L;
        if (NotEnoughUpdates.INSTANCE.config.profileViewer.useSoopyNetworth) {
            weight = profile.getSoopyWeightLeaderboardPosition();
        }
        Utils.drawStringCentered(EnumChatFormatting.GREEN + "Senither Weight: " + EnumChatFormatting.GOLD + StringUtils.formatNumber(Utils.roundToNearestInt(senitherWeight.getTotalWeight().getRaw())), guiLeft + 63, guiTop + 18, true, 0);
        int textWidth = fr.func_78256_a("Senither Weight: " + StringUtils.formatNumber(Utils.roundToNearestInt(senitherWeight.getTotalWeight().getRaw())));
        if (mouseX > guiLeft + 63 - textWidth / 2 && mouseX < guiLeft + 63 + textWidth / 2 && mouseY > guiTop + 12 && mouseY < guiTop + 12 + fr.field_78288_b) {
            this.getInstance().tooltipToDisplay = new ArrayList<String>();
            this.getInstance().tooltipToDisplay.add(EnumChatFormatting.GREEN + "Skills: " + EnumChatFormatting.GOLD + StringUtils.formatNumber(Utils.roundToNearestInt(senitherWeight.getSkillsWeight().getWeightStruct().getRaw())));
            this.getInstance().tooltipToDisplay.add(EnumChatFormatting.GREEN + "Slayer: " + EnumChatFormatting.GOLD + StringUtils.formatNumber(Utils.roundToNearestInt(senitherWeight.getSlayerWeight().getWeightStruct().getRaw())));
            this.getInstance().tooltipToDisplay.add(EnumChatFormatting.GREEN + "Dungeons: " + EnumChatFormatting.GOLD + StringUtils.formatNumber(Utils.roundToNearestInt(senitherWeight.getDungeonsWeight().getWeightStruct().getRaw())));
            if (NotEnoughUpdates.INSTANCE.config.profileViewer.useSoopyNetworth && profile.isProfileMaxSoopyWeight(profileName)) {
                String lbPosStr = EnumChatFormatting.DARK_GREEN + "#" + EnumChatFormatting.GOLD + StringUtils.formatNumber(profile.getSoopyWeightLeaderboardPosition());
                this.getInstance().tooltipToDisplay.add("");
                String stateStr = EnumChatFormatting.RED + "An error occurred";
                if (weight == -2L) {
                    stateStr = EnumChatFormatting.YELLOW + "Loading";
                }
                if (weight > 0L) {
                    this.getInstance().tooltipToDisplay.add(lbPosStr + EnumChatFormatting.GREEN + " on soopy's weight leaderboard!");
                } else {
                    this.getInstance().tooltipToDisplay.add(stateStr + " on soopy's weight leaderboard");
                }
            }
        }
        Utils.drawStringCentered(EnumChatFormatting.GREEN + "Lily Weight: " + EnumChatFormatting.GOLD + StringUtils.formatNumber(Utils.roundToNearestInt(lilyWeight.getTotalWeight().getRaw())), guiLeft + 63, guiTop + 28, true, 0);
        int fontWidth = fr.func_78256_a("Lily Weight: " + StringUtils.formatNumber(Utils.roundToNearestInt(lilyWeight.getTotalWeight().getRaw())));
        if (mouseX > guiLeft + 63 - fontWidth / 2 && mouseX < guiLeft + 63 + fontWidth / 2 && mouseY > guiTop + 22 && mouseY < guiTop + 22 + fr.field_78288_b) {
            this.getInstance().tooltipToDisplay = new ArrayList<String>();
            this.getInstance().tooltipToDisplay.add(EnumChatFormatting.GREEN + "Skills: " + EnumChatFormatting.GOLD + StringUtils.formatNumber(Utils.roundToNearestInt(lilyWeight.getSkillsWeight().getWeightStruct().getRaw())));
            this.getInstance().tooltipToDisplay.add(EnumChatFormatting.GREEN + "Slayer: " + EnumChatFormatting.GOLD + StringUtils.formatNumber(Utils.roundToNearestInt(lilyWeight.getSlayerWeight().getWeightStruct().getRaw())));
            this.getInstance().tooltipToDisplay.add(EnumChatFormatting.GREEN + "Dungeons: " + EnumChatFormatting.GOLD + StringUtils.formatNumber(Utils.roundToNearestInt(lilyWeight.getDungeonsWeight().getWeightStruct().getRaw())));
        }
    }

    private void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent) {
        ent.func_70071_h_();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float renderYawOffset = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_147940_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        ent.field_70761_aq = renderYawOffset;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        int i = ProfileViewerUtils.onSlotToChangePage(mouseX, mouseY, guiLeft, guiTop);
        switch (i) {
            case 1: {
                GuiProfileViewer.onSecondPage = false;
                break;
            }
            case 2: {
                GuiProfileViewer.onSecondPage = true;
                break;
            }
        }
        return false;
    }

    public void drawSideButtons(int mouseX, int mouseY) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)5.0f);
        if (GuiProfileViewer.onSecondPage) {
            Utils.drawPvSideButton(1, pageModeIcon.get("second_page"), true, this.guiProfileViewer, mouseX, mouseY);
        } else {
            Utils.drawPvSideButton(0, pageModeIcon.get("first_page"), true, this.guiProfileViewer, mouseX, mouseY);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-3.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2.0f);
        if (!GuiProfileViewer.onSecondPage) {
            Utils.drawPvSideButton(1, pageModeIcon.get("second_page"), false, this.guiProfileViewer, mouseX, mouseY);
        } else {
            Utils.drawPvSideButton(0, pageModeIcon.get("first_page"), false, this.guiProfileViewer, mouseX, mouseY);
        }
        GlStateManager.func_179097_i();
    }
}

