/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.GlScissorStack;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.GuiProfileViewerPage;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.profileviewer.SkyblockProfiles;
import io.github.moulberry.notenoughupdates.profileviewer.data.APIDataJson;
import io.github.moulberry.notenoughupdates.profileviewer.hotm.HotmTreeRenderer;
import io.github.moulberry.notenoughupdates.recipes.ForgeRecipe;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.util.ItemResolutionQuery;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Mouse;

public class MiningPage
extends GuiProfileViewerPage {
    private static final ResourceLocation miningPageTexture = new ResourceLocation("notenoughupdates:profile_viewer/mining/background.png");
    private static final ResourceLocation FORGE_SLOT_BACKGROUND = new ResourceLocation("notenoughupdates:profile_viewer/mining/perk_background.png");
    private static final ItemStack hotmSkillIcon = new ItemStack(Items.field_151035_b);
    private static final Map<String, EnumChatFormatting> crystalToColor = new LinkedHashMap<String, EnumChatFormatting>(){
        {
            this.put("jade", EnumChatFormatting.GREEN);
            this.put("amethyst", EnumChatFormatting.DARK_PURPLE);
            this.put("amber", EnumChatFormatting.GOLD);
            this.put("sapphire", EnumChatFormatting.AQUA);
            this.put("topaz", EnumChatFormatting.YELLOW);
            this.put("jasper", EnumChatFormatting.LIGHT_PURPLE);
            this.put("ruby", EnumChatFormatting.RED);
            this.put("opal", EnumChatFormatting.WHITE);
            this.put("aquamarine", EnumChatFormatting.BLUE);
            this.put("peridot", EnumChatFormatting.DARK_GREEN);
            this.put("onyx", EnumChatFormatting.DARK_GRAY);
            this.put("citrine", EnumChatFormatting.DARK_RED);
        }
    };
    int scroll = 0;

    public MiningPage(GuiProfileViewer instance) {
        super(instance);
    }

    @Override
    public void drawPage(int mouseX, int mouseY, float partialTicks) {
        int rectYSize;
        int guiLeft = GuiProfileViewer.getGuiLeft();
        int guiTop = GuiProfileViewer.getGuiTop();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(miningPageTexture);
        Utils.drawTexturedRect(guiLeft, guiTop, this.getInstance().sizeX, this.getInstance().sizeY, 9728);
        SkyblockProfiles.SkyblockProfile selectedProfile = this.getSelectedProfile();
        if (selectedProfile == null) {
            return;
        }
        APIDataJson data = selectedProfile.getAPIDataJson();
        if (data == null) {
            return;
        }
        APIDataJson.MiningCore core = data.mining_core;
        Map<String, JsonElement> nodes = core.nodes;
        JsonObject profileInfo2 = selectedProfile.getProfileJson();
        float xStart = 22.0f;
        float yStartTop = 27.0f;
        int x = guiLeft + 23;
        int y = guiTop + 25;
        int sectionWidth = 110;
        JsonElement miningCore = profileInfo2.get("mining_core");
        float mithrilPowder = core.powder_mithril;
        float gemstonePowder = core.powder_gemstone;
        float glacitePowder = core.powder_glacite;
        float mithrilPowderTotal = core.powder_spent_mithril;
        float gemstonePowderTotal = core.powder_spent_gemstone;
        float glacitePowderTotal = core.powder_spent_glacite;
        double nucleusRunsCompleted = Stream.of("amber", "amethyst", "jade", "sapphire", "topaz").mapToDouble(crystal -> Utils.getElementAsFloat(Utils.getElement(miningCore, "crystals." + crystal + "_crystal.total_placed"), 0.0f)).min().orElse(0.0);
        Map<String, ProfileViewer.Level> levelingInfo = selectedProfile.getLevelingInfo();
        ProfileViewer.Level hotmLevelingInfo = null;
        if (levelingInfo != null) {
            hotmLevelingInfo = levelingInfo.get("hotm");
            this.getInstance().renderXpBar(EnumChatFormatting.RED + "HOTM", hotmSkillIcon, x, y, sectionWidth, hotmLevelingInfo, mouseX, mouseY);
        }
        Utils.renderAlignedString(EnumChatFormatting.DARK_GREEN + "Mithril", "", (float)guiLeft + xStart + 45.0f, (float)guiTop + yStartTop + 24.0f, 115);
        Utils.renderAlignedString(EnumChatFormatting.LIGHT_PURPLE + "Gemstone", "", (float)guiLeft + xStart + 85.0f, (float)guiTop + yStartTop + 24.0f, 115);
        Utils.renderAlignedString(EnumChatFormatting.AQUA + "Glacite", "", (float)guiLeft + xStart + 145.0f, (float)guiTop + yStartTop + 24.0f, 115);
        Utils.renderAlignedString(EnumChatFormatting.WHITE + "Powder:", "", (float)guiLeft + xStart, (float)guiTop + yStartTop + 44.0f, 115);
        Utils.renderAlignedString(EnumChatFormatting.DARK_GREEN + StringUtils.shortNumberFormat(mithrilPowder), "", (float)guiLeft + xStart + 50.0f, (float)guiTop + yStartTop + 44.0f, 115);
        Utils.renderAlignedString(EnumChatFormatting.LIGHT_PURPLE + StringUtils.shortNumberFormat(gemstonePowder), "", (float)guiLeft + xStart + 100.0f, (float)guiTop + yStartTop + 44.0f, 115);
        Utils.renderAlignedString(EnumChatFormatting.AQUA + StringUtils.shortNumberFormat(glacitePowder), "", (float)guiLeft + xStart + 150.0f, (float)guiTop + yStartTop + 44.0f, 115);
        Utils.renderAlignedString(EnumChatFormatting.WHITE + "Total:", "", (float)guiLeft + xStart, (float)guiTop + yStartTop + 54.0f, 115);
        Utils.renderAlignedString(EnumChatFormatting.DARK_GREEN + StringUtils.shortNumberFormat(mithrilPowder + mithrilPowderTotal), "", (float)guiLeft + xStart + 50.0f, (float)guiTop + yStartTop + 54.0f, 115);
        Utils.renderAlignedString(EnumChatFormatting.LIGHT_PURPLE + StringUtils.shortNumberFormat(gemstonePowder + gemstonePowderTotal), "", (float)guiLeft + xStart + 100.0f, (float)guiTop + yStartTop + 54.0f, 115);
        Utils.renderAlignedString(EnumChatFormatting.AQUA + StringUtils.shortNumberFormat(glacitePowder + glacitePowderTotal), "", (float)guiLeft + xStart + 150.0f, (float)guiTop + yStartTop + 54.0f, 115);
        int padding = 4;
        int rectStartX = 16;
        rectStartX += padding;
        int rectStartY = 97;
        rectStartY += padding;
        int rectXSize = 214;
        rectXSize -= padding * 2;
        int originalRectYSize = rectYSize = 89;
        rectYSize -= padding * 2;
        int rowHeight = 10;
        int totalColumns = 2;
        rectYSize = rowHeight * (int)Math.ceil((double)crystalToColor.size() / (double)totalColumns);
        int totalRows = rectYSize / rowHeight;
        int idx = 0;
        for (Map.Entry<String, EnumChatFormatting> crystal2 : crystalToColor.entrySet()) {
            int currentRow = idx % totalRows;
            int currentCol = idx / totalRows;
            int columnWidth = rectXSize / totalColumns - padding / totalColumns;
            int columnOffset = columnWidth + padding;
            String crystalState = Utils.getElementAsString(Utils.getElement(miningCore, "crystals." + crystal2.getKey() + "_crystal.state"), "NOT_FOUND");
            String crystalStr = crystalState.equals("FOUND") ? "\u00a7a\u2714" : "\u00a7c\u2716";
            Utils.renderAlignedString(crystal2.getValue() + WordUtils.capitalizeFully((String)crystal2.getKey()) + ":", EnumChatFormatting.WHITE + crystalStr, guiLeft + rectStartX + currentCol * columnOffset, guiTop + rectStartY + currentRow * rowHeight, columnWidth);
            ++idx;
        }
        Utils.renderAlignedString(EnumChatFormatting.BLUE + "Nucleus Runs Completed:", EnumChatFormatting.WHITE + StringUtils.formatNumber(nucleusRunsCompleted), guiLeft + rectStartX, (float)(guiTop + rectStartY + originalRectYSize - padding) - 1.5f * (float)Minecraft.func_71410_x().field_71466_p.field_78288_b, rectXSize);
        this.renderHotmTree(guiLeft + 249, guiTop + 16, guiLeft + 412, guiTop + 185, nodes, mouseX, mouseY, hotmLevelingInfo);
        int forgeX = guiLeft + 149;
        int forgeY = guiTop + 20;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(FORGE_SLOT_BACKGROUND);
        Utils.drawTexturedRect(forgeX, forgeY, 16.0f, 16.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        ItemStack anvil = new ItemStack(Item.func_150898_a((Block)Blocks.field_150467_bQ));
        Utils.drawItemStack(anvil, forgeX, forgeY);
        if (mouseX >= forgeX && mouseX < forgeX + 16 && mouseY >= forgeY && mouseY < forgeY + 16) {
            if (data.forge == null) {
                return;
            }
            if (data.forge.forge_processes == null) {
                return;
            }
            Map<String, APIDataJson.ForgeData.ForgeProcessesData.Node> forgeData = data.forge.forge_processes.forge_1;
            if (forgeData == null) {
                return;
            }
            ArrayList<String> tooltip = new ArrayList<String>();
            ItemResolutionQuery itemResolutionQuery = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery();
            int hotmLevel = 0;
            if (hotmLevelingInfo != null) {
                hotmLevel = (int)Math.floor(hotmLevelingInfo.level);
            }
            ArrayList<String> forgeSlots = new ArrayList<String>(){
                {
                    this.add("1: \u00a7cEmpty");
                    this.add("2: \u00a7cEmpty");
                    this.add("3: \u00a77Locked");
                    this.add("4: \u00a77Locked");
                    this.add("5: \u00a77Locked");
                    this.add("6: \u00a77Locked");
                    this.add("7: \u00a77Locked");
                }
            };
            for (int i = 2; i < 7; ++i) {
                if (hotmLevel <= i) continue;
                forgeSlots.set(i, i + 1 + ": \u00a7cEmpty");
            }
            long currentTime = System.currentTimeMillis();
            boolean showError = false;
            for (APIDataJson.ForgeData.ForgeProcessesData.Node value : forgeData.values()) {
                String id;
                Set<NeuRecipe> recipes;
                if (value.slot > 7) {
                    forgeSlots.add(value.slot + ": \u00a7cEmpty");
                }
                if ((recipes = NotEnoughUpdates.INSTANCE.manager.getRecipesFor(id = value.id)).isEmpty() && value.type.equals("PETS")) {
                    id = id + ";4";
                    recipes = NotEnoughUpdates.INSTANCE.manager.getRecipesFor(id);
                }
                if (recipes != null) {
                    long startTime;
                    long durationLeft;
                    ForgeRecipe forgeRecipe = null;
                    for (NeuRecipe recipe : recipes) {
                        if (!(recipe instanceof ForgeRecipe)) continue;
                        forgeRecipe = (ForgeRecipe)recipe;
                        break;
                    }
                    if (forgeRecipe == null) {
                        tooltip.add("\u00a7cMissing recipe " + id);
                        showError = true;
                    }
                    int level = 0;
                    JsonObject hotm = miningCore.getAsJsonObject();
                    if (hotm.has("nodes") && hotm.get("nodes").getAsJsonObject().has("forge_time")) {
                        level = hotm.get("nodes").getAsJsonObject().get("forge_time").getAsInt();
                    }
                    int duration = 0;
                    if (forgeRecipe != null) {
                        duration = forgeRecipe.getReducedTime(level);
                    }
                    boolean finished = (durationLeft = (startTime = value.startTime / 1000L * 1000L) + (long)(duration *= 1000) - currentTime) < 0L;
                    ItemStack itemStack = itemResolutionQuery.withKnownInternalName(id).resolveToItemStack();
                    String displayName = id;
                    if (itemStack == null) {
                        tooltip.add("\u00a7cMissing item " + id);
                        showError = true;
                    } else {
                        displayName = itemStack.func_82833_r().replace("[Lvl {LVL}] ", "");
                    }
                    if (forgeRecipe == null) {
                        forgeSlots.set(value.slot - 1, value.slot + ": \u00a74" + displayName + " \u00a77Time Remaining: \u00a7cUnknown");
                        continue;
                    }
                    if (finished) {
                        forgeSlots.set(value.slot - 1, value.slot + ": \u00a74" + displayName + " \u00a7aCompleted!");
                        continue;
                    }
                    forgeSlots.set(value.slot - 1, value.slot + ": \u00a74" + displayName + " \u00a77Time Remaining: \u00a7a" + Utils.prettyTime(durationLeft));
                    continue;
                }
                tooltip.add("\u00a7cCant find item: " + value.id);
                showError = true;
            }
            if (showError) {
                tooltip.add("\u00a7cPlease report this to the NEU Discord");
                tooltip.add("\u00a7c" + Utils.getDiscordInvite());
            }
            tooltip.add(EnumChatFormatting.GOLD + "Forge");
            tooltip.add("");
            tooltip.addAll(forgeSlots);
            this.getInstance().tooltipToDisplay = tooltip;
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private void renderHotmTree(int left, int top, int right, int bottom, Map<String, JsonElement> levels, int mouseX, int mouseY, @Nullable ProfileViewer.Level hotmLevelingInfo) {
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        GlScissorStack.push(left, top, right, bottom, sr);
        boolean isHovered = left < mouseX && mouseX < right && top < mouseY && mouseY < bottom;
        HotmTreeRenderer renderer = HotmTreeRenderer.Companion.getRenderer();
        if (isHovered) {
            this.scroll += Mouse.getDWheel();
        }
        if (renderer != null) {
            int maxScroll = renderer.getYSize() * 24 - (bottom - top) - 12;
            this.scroll = Math.min(maxScroll + 4, Math.max(0, this.scroll));
            renderer.renderPerks(levels, hotmLevelingInfo, left + (right - left) / 2 - renderer.getXSize() * 24 / 2 + 2, top - maxScroll + this.scroll, mouseX, mouseY, isHovered, 20, 4);
        } else {
            Utils.showOutdatedRepoNotification("hotmLayout.json");
        }
        GlScissorStack.pop(sr);
    }
}

