/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.profileviewer;

import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

public class Panorama {
    private static final HashMap<String, ResourceLocation[]> panoramasMap = new HashMap();
    private static ResourceLocation backgroundTexture = null;
    private static int lastWidth = 0;
    private static int lastHeight = 0;

    public static synchronized ResourceLocation[] getPanoramasForLocation(String location, String identifier) {
        if (panoramasMap.containsKey(location + identifier)) {
            return panoramasMap.get(location + identifier);
        }
        try {
            ResourceLocation[] panoramasArray = new ResourceLocation[6];
            for (int i = 0; i < 6; ++i) {
                panoramasArray[i] = new ResourceLocation("notenoughupdates:panoramas/" + location + "_" + identifier + "/panorama_" + i + ".jpg");
                Minecraft.func_71410_x().func_110442_L().func_110536_a(panoramasArray[i]);
            }
            panoramasMap.put(location + identifier, panoramasArray);
            return panoramasArray;
        }
        catch (IOException e2) {
            try {
                ResourceLocation[] panoramasArray = new ResourceLocation[6];
                for (int i = 0; i < 6; ++i) {
                    panoramasArray[i] = new ResourceLocation("notenoughupdates:panoramas/" + location + "/panorama_" + i + ".jpg");
                    Minecraft.func_71410_x().func_110442_L().func_110536_a(panoramasArray[i]);
                }
                panoramasMap.put(location + identifier, panoramasArray);
                return panoramasArray;
            }
            catch (IOException e22) {
                ResourceLocation[] panoramasArray = new ResourceLocation[6];
                for (int i = 0; i < 6; ++i) {
                    panoramasArray[i] = new ResourceLocation("notenoughupdates:panoramas/unknown/panorama_" + i + ".jpg");
                }
                panoramasMap.put(location + identifier, panoramasArray);
                return panoramasArray;
            }
        }
    }

    public static void drawPanorama(float angle, int x, int y, int width, int height, float yOffset, float zOffset, ResourceLocation[] panoramas) {
        if (!OpenGlHelper.func_148822_b()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(panoramas[0]);
            float aspect = (float)width / (float)height;
            Utils.drawTexturedRect(x, y, width, height, 0.5f - aspect / 2.0f, 0.5f + aspect / 2.0f, 0.0f, 1.0f);
            return;
        }
        Minecraft.func_71410_x().func_147110_a().func_147609_e();
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        GL11.glViewport((int)0, (int)0, (int)(width * scaledresolution.func_78325_e()), (int)(height * scaledresolution.func_78325_e()));
        float fov = 97.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        Project.gluPerspective((float)fov, (float)((float)height / (float)width), (float)0.05f, (float)10.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)19.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)yOffset, (float)zOffset);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        for (int k = 0; k < 6; ++k) {
            GlStateManager.func_179094_E();
            switch (k) {
                case 1: {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 2: {
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 3: {
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 4: {
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case 5: {
                    GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(panoramas[k]);
            float splits = 0.1f;
            for (float x1 = 0.0f; x1 < 1.0f; x1 += splits) {
                for (float y1 = 0.0f; y1 < 1.0f; y1 += splits) {
                    worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    for (int i = 0; i < 4; ++i) {
                        float x2 = i == 0 || i == 3 ? x1 : x1 + splits;
                        float y2 = i >= 2 ? y1 : y1 + splits;
                        float xr = x2 * 2.0f - 1.0f;
                        float yr = y2 * 2.0f - 1.0f;
                        float distSq = xr * xr + yr * yr + 1.0f;
                        float scale = (float)Math.sqrt(3.0f / distSq);
                        worldrenderer.func_181662_b((double)(xr * scale), (double)(yr * scale), (double)scale).func_181673_a((double)x2, (double)y2).func_181669_b(255, 255, 255, 255).func_181675_d();
                    }
                    tessellator.func_78381_a();
                }
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        worldrenderer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179126_j();
        if (backgroundTexture == null || lastWidth != width * scaledresolution.func_78325_e() || lastHeight != height * scaledresolution.func_78325_e()) {
            DynamicTexture viewportTexture = new DynamicTexture(width * scaledresolution.func_78325_e(), height * scaledresolution.func_78325_e());
            backgroundTexture = Minecraft.func_71410_x().func_110434_K().func_110578_a("background", viewportTexture);
            lastWidth = width * scaledresolution.func_78325_e();
            lastHeight = height * scaledresolution.func_78325_e();
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(backgroundTexture);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)(width * scaledresolution.func_78325_e()), (int)(height * scaledresolution.func_78325_e()));
        Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
        tessellator = Tessellator.func_178181_a();
        worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181673_a(0.0, 1.0).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a(0.0, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)y, 0.0).func_181673_a(1.0, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, 0.0).func_181673_a(1.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

