/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.recipes;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.miscgui.GuiItemRecipe;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.recipes.Ingredient;
import io.github.moulberry.notenoughupdates.recipes.NeuRecipe;
import io.github.moulberry.notenoughupdates.recipes.RecipeSlot;
import io.github.moulberry.notenoughupdates.recipes.RecipeType;
import io.github.moulberry.notenoughupdates.util.HotmInformation;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class ForgeRecipe
implements NeuRecipe {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("notenoughupdates", "textures/gui/forge_recipe_tall.png");
    private static final int SLOT_IMAGE_U = 176;
    private static final int SLOT_IMAGE_V = 0;
    private static final int SLOT_IMAGE_SIZE = 18;
    private static final int SLOT_PADDING = 1;
    private static final int EXTRA_INFO_MAX_WIDTH = 75;
    public static final int EXTRA_INFO_X = 132;
    public static final int EXTRA_INFO_Y = 55;
    private final NEUManager manager;
    private final List<Ingredient> inputs;
    private final Ingredient output;
    private final int hotmLevel;
    private final int timeInSeconds;
    private List<RecipeSlot> slots;
    private static final int RECIPE_CENTER_X = 49;
    private static final int RECIPE_CENTER_Y = 74;
    private static final int SLOT_DISTANCE_FROM_CENTER = 30;
    private static final int RECIPE_FALLBACK_X = 20;
    private static final int RECIPE_FALLBACK_Y = 15;

    public ForgeRecipe(NEUManager manager, List<Ingredient> inputs, Ingredient output, int durationInSeconds, int hotmLevel) {
        this.manager = manager;
        this.inputs = inputs;
        this.output = output;
        this.hotmLevel = hotmLevel;
        this.timeInSeconds = durationInSeconds;
    }

    public List<Ingredient> getInputs() {
        return this.inputs;
    }

    public Ingredient getOutput() {
        return this.output;
    }

    public int getTimeInSeconds() {
        return this.timeInSeconds;
    }

    @Override
    public ResourceLocation getBackground() {
        return BACKGROUND;
    }

    @Override
    public RecipeType getType() {
        return RecipeType.FORGE;
    }

    @Override
    public Set<Ingredient> getIngredients() {
        return Sets.newHashSet(this.inputs);
    }

    @Override
    public boolean hasVariableCost() {
        return false;
    }

    @Override
    public Set<Ingredient> getOutputs() {
        return Collections.singleton(this.output);
    }

    @Override
    public List<RecipeSlot> getSlots() {
        if (this.slots != null) {
            return this.slots;
        }
        this.slots = new ArrayList<RecipeSlot>();
        for (int i = 0; i < this.inputs.size(); ++i) {
            Ingredient input = this.inputs.get(i);
            ItemStack itemStack = input.getItemStack();
            if (itemStack == null) continue;
            int[] slotCoordinates = ForgeRecipe.getSlotCoordinates(i, this.inputs.size());
            this.slots.add(new RecipeSlot(slotCoordinates[0], slotCoordinates[1], itemStack));
        }
        this.slots.add(new RecipeSlot(124, 66, this.output.getItemStack()));
        return this.slots;
    }

    @Override
    public void drawExtraBackground(GuiItemRecipe gui, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        for (int i = 0; i < this.inputs.size(); ++i) {
            int[] slotCoordinates = ForgeRecipe.getSlotCoordinates(i, this.inputs.size());
            gui.func_73729_b(gui.guiLeft + slotCoordinates[0] - 1, gui.guiTop + slotCoordinates[1] - 1, 176, 0, 18, 18);
        }
    }

    @Override
    public void drawExtraInfo(GuiItemRecipe gui, int mouseX, int mouseY) {
        if (this.timeInSeconds > 0) {
            Utils.drawStringCenteredScaledMaxWidth(ForgeRecipe.formatDuration(this.timeInSeconds), gui.guiLeft + 132, gui.guiTop + 55, false, 75, 0xFF00FF);
        }
    }

    @Override
    public void drawHoverInformation(GuiItemRecipe gui, int mouseX, int mouseY) {
        NEUConfig.HiddenProfileSpecific profileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        if (profileSpecific == null) {
            return;
        }
        if (this.timeInSeconds <= 0 || !gui.isWithinRect(mouseX, mouseY, gui.guiLeft + 132 - 37, gui.guiTop + 55 - 8, 75, 16)) {
            return;
        }
        int level = profileSpecific.hotmTree.getOrDefault("Quick Forge", 0);
        if (level == 0) {
            return;
        }
        int reducedTime = this.getReducedTime(level);
        Utils.drawHoveringText(Collections.singletonList(EnumChatFormatting.YELLOW + ForgeRecipe.formatDuration(reducedTime) + " with Quick Forge (Level " + level + ")"), mouseX, mouseY, gui.field_146294_l, gui.field_146295_m, 500);
    }

    public int getReducedTime(int quickForgeUpgradeLevel) {
        return HotmInformation.getQuickForgeMultiplier(quickForgeUpgradeLevel) * this.timeInSeconds / 1000;
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        JsonArray ingredients = new JsonArray();
        for (Ingredient input : this.inputs) {
            ingredients.add(new JsonPrimitive(input.serialize()));
        }
        object.addProperty("type", "forge");
        object.add("inputs", ingredients);
        object.addProperty("count", this.output.getCount());
        object.addProperty("overrideOutputId", this.output.getInternalItemId());
        if (this.hotmLevel >= 0) {
            object.addProperty("hotmLevel", this.hotmLevel);
        }
        if (this.timeInSeconds >= 0) {
            object.addProperty("duration", this.timeInSeconds);
        }
        return object;
    }

    static ForgeRecipe parseForgeRecipe(NEUManager manager, JsonObject recipe, JsonObject output) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (JsonElement element : recipe.getAsJsonArray("inputs")) {
            String ingredientString = element.getAsString();
            ingredients.add(new Ingredient(manager, ingredientString));
        }
        String internalItemId = output.get("internalname").getAsString();
        if (recipe.has("overrideOutputId")) {
            internalItemId = recipe.get("overrideOutputId").getAsString();
        }
        int resultCount = 1;
        if (recipe.has("count")) {
            resultCount = recipe.get("count").getAsInt();
        }
        int duration = -1;
        if (recipe.has("duration")) {
            duration = recipe.get("duration").getAsInt();
        }
        int hotmLevel = -1;
        if (recipe.has("hotmLevel")) {
            hotmLevel = recipe.get("hotmLevel").getAsInt();
        }
        return new ForgeRecipe(manager, ingredients, new Ingredient(manager, internalItemId, resultCount), duration, hotmLevel);
    }

    static int[] getSlotCoordinates(int slotNumber, int totalSlotCount) {
        if (totalSlotCount > 8) {
            return new int[]{20 + slotNumber % 4 * 18, 15 + slotNumber / 4 * 18};
        }
        if (totalSlotCount == 1) {
            return new int[]{41, 66};
        }
        double rad2 = Math.PI * 2 * (double)slotNumber / (double)totalSlotCount;
        int x = (int)(Math.cos(rad2) * 30.0);
        int y = (int)(Math.sin(rad2) * 30.0);
        return new int[]{49 + x - 8, 74 + y - 8};
    }

    static String formatDuration(int seconds) {
        int minutes = seconds / 60;
        seconds %= 60;
        int hours = minutes / 60;
        minutes %= 60;
        int days = hours / 24;
        hours %= 24;
        StringBuilder sB = new StringBuilder();
        if (days != 0) {
            sB.append(days).append("d ");
        }
        if (hours != 0) {
            sB.append(hours).append("h ");
        }
        if (minutes != 0) {
            sB.append(minutes).append("m ");
        }
        if (seconds != 0) {
            sB.append(seconds).append("s ");
        }
        return sB.substring(0, sB.length() - 1);
    }

    public static enum ForgeType {
        REFINING,
        ITEM_FORGING;

    }
}

