/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.JsonUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class PronounDB {
    public static CompletableFuture<Optional<JsonObject>> performPronouning(String platform, String id) {
        if (PronounDB.isDisabledByRepo()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return NotEnoughUpdates.INSTANCE.manager.apiUtils.request().url("https://pronoundb.org/api/v2/lookup").queryArgument("platform", platform).queryArgument("ids", id).requestJson().handle((result2, ex) -> Optional.ofNullable(result2));
    }

    private static boolean isDisabledByRepo() {
        JsonObject disabled = Constants.DISABLE;
        return disabled != null && disabled.has("pronoundb");
    }

    public static CompletableFuture<Optional<PronounChoice>> getPronounsFor(String platform, String name) {
        return PronounDB.performPronouning(platform, name).thenApply(it -> it.flatMap(jsonObject -> PronounDB.parsePronouns(jsonObject, name)));
    }

    private static Optional<PronounChoice> parsePronouns(JsonObject pronounObject, String name) {
        if (pronounObject.has(name)) {
            List<String> set = JsonUtils.transformJsonArrayToList(Utils.getElementOrDefault(pronounObject, name + ".sets.en", new JsonArray()).getAsJsonArray(), JsonElement::getAsString);
            List pronouns2 = set.stream().map(pronounId -> Arrays.stream(Pronoun.values()).filter(pronoun -> ((Pronoun)pronoun).id.equals(pronounId)).findFirst().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
            if (pronouns2.isEmpty()) {
                return Optional.empty();
            }
            if (pronouns2.size() >= 2) {
                return Optional.of(new PronounChoice((Pronoun)((Object)pronouns2.get(0)), (Pronoun)((Object)pronouns2.get(1))));
            }
            return Optional.of(new PronounChoice((Pronoun)((Object)pronouns2.get(0)), null));
        }
        return Optional.empty();
    }

    public static CompletableFuture<Optional<PronounChoice>> getPronounsFor(UUID minecraftPlayer) {
        return PronounDB.getPronounsFor("minecraft", minecraftPlayer.toString());
    }

    public static void test(UUID uuid) {
        System.out.println("Pronouning...");
        PronounDB.getPronounsFor(uuid).thenAccept(it -> {
            PronounChoice pronounsFor = (PronounChoice)it.get();
            System.out.println(pronounsFor.render());
            Utils.addChatMessage(pronounsFor.render());
        });
    }

    public static class PronounChoice {
        private final Pronoun firstPronoun;
        private final Pronoun secondPronoun;

        PronounChoice(Pronoun firstPronoun, Pronoun secondPronoun) {
            this.firstPronoun = firstPronoun;
            this.secondPronoun = secondPronoun;
        }

        public String render() {
            if (this.firstPronoun.override != null) {
                return this.firstPronoun.override;
            }
            if (this.secondPronoun == null) {
                return this.firstPronoun.id + "/" + this.firstPronoun.object;
            }
            return this.firstPronoun.id + "/" + this.secondPronoun.id;
        }

        public Pronoun getFirstPronoun() {
            return this.firstPronoun;
        }

        public Pronoun getSecondPronoun() {
            return this.secondPronoun;
        }
    }

    public static enum Pronoun {
        HE("he", "him"),
        IT("it", "its"),
        SHE("she", "her"),
        THEY("they", "them"),
        ANY("any", null, "Any pronouns"),
        OTHER("other", null, "Other"),
        ASK("ask", null, "Ask for pronouns"),
        AVOID("avoid", null, "Avoid pronouns");

        private final String id;
        private final String object;
        private final String override;

        private Pronoun(String id, String object) {
            this.id = id;
            this.object = object;
            this.override = null;
        }

        private Pronoun(String id, String object, String override) {
            this.id = id;
            this.object = object;
            this.override = override;
        }

        public String getId() {
            return this.id;
        }

        public String getObject() {
            return this.object;
        }

        public String getOverride() {
            return this.override;
        }
    }
}

