/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.util;

import io.github.moulberry.notenoughupdates.util.Utils;
import java.time.Instant;

public class StarCultCalculator {
    public static final String[] SEASONS = new String[]{"Early Spring", "Spring", "Late Spring", "Early Summer", "Summer", "Late Summer", "Early Autumn", "Autumn", "Late Autumn", "Early Winter", "Winter", "Late Winter"};
    public static final long HOUR_MS = 50000L;
    public static final long DAY_MS = 1200000L;
    public static final long MONTH_MS = 37200000L;
    public static final long YEAR_MS = (long)SEASONS.length * 37200000L;
    public static final long YEAR_0 = 1560275700000L;
    private static boolean active = false;
    private static long activeTill = 0L;

    public static int getSkyblockYear() {
        long now = Instant.now().toEpochMilli();
        long currentYear = Math.floorDiv(now - 1560275700000L, YEAR_MS);
        return (int)(currentYear + 1L);
    }

    public static String getNextStarCult() {
        Instant cultStart = StarCultCalculator.getNextStarCultTime();
        long l = System.currentTimeMillis();
        if (cultStart.toEpochMilli() - l <= 1000L) {
            active = true;
            activeTill = l + 300000L;
        }
        if (l > activeTill) {
            active = false;
            activeTill = 0L;
        }
        if (active && activeTill != 0L) {
            return "Active! (" + Utils.prettyTime(activeTill - System.currentTimeMillis()) + ")";
        }
        return Utils.prettyTime(cultStart.toEpochMilli() - l);
    }

    public static Instant getNextStarCultTime() {
        return StarCultCalculator.getNextStarCultTime(Instant.now());
    }

    public static Instant getNextStarCultTime(Instant after) {
        long nowEpoch = after.toEpochMilli();
        long currentOffset = (nowEpoch - 1560275700000L) % YEAR_MS;
        int currentMonth = (int)Math.floorDiv(currentOffset, 37200000L);
        int currentDay = (int)Math.floorDiv((currentOffset - (long)currentMonth * 37200000L) % 37200000L, 1200000L) + 1;
        int out = 7;
        if (currentDay > 21) {
            out = 28;
        } else if (currentDay > 14) {
            out = 21;
        } else if (currentDay > 7) {
            out = 14;
        }
        Instant cultStart = Instant.ofEpochMilli(1560275700000L + (long)(StarCultCalculator.getSkyblockYear() - 1) * YEAR_MS + (long)currentMonth * 37200000L + (long)(out - 1) * 1200000L);
        if (cultStart.isBefore(after)) {
            int curYearCult = StarCultCalculator.getSkyblockYear() - 1;
            if (out == 28) {
                out = 7;
                if (currentMonth == 12) {
                    currentMonth = 1;
                    ++curYearCult;
                } else {
                    ++currentMonth;
                }
            } else {
                out += 7;
            }
            cultStart = Instant.ofEpochMilli(1560275700000L + (long)curYearCult * YEAR_MS + (long)currentMonth * 37200000L + (long)(--out) * 1200000L);
        }
        return cultStart;
    }
}

