/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.justutilities.physics.collision;

import net.dark_roleplay.justutilities.physics.collision.IBoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class OrientedBB
implements IBoundingBox {
    private Vec3 pos;
    private AABB aabb;
    private Vec3[] axes = new Vec3[3];
    private Vec3[] verts = new Vec3[8];
    private float rotX;
    private float rotY;
    private float rotZ;

    public OrientedBB(AABB aabb, Vec3 origin) {
        this(aabb, origin, 0.0f, 0.0f, 0.0f);
    }

    public OrientedBB(AABB aabb, Vec3 pos, float rotX, float rotY, float rotZ) {
        this.aabb = aabb;
        this.pos = pos;
        this.setRotation(rotX, rotY, rotZ);
        this.update();
    }

    @Override
    public void setPos(Vec3 pos) {
        this.pos = pos;
        this.update();
    }

    @Override
    public void move(Vec3 pos) {
        this.pos = this.pos.m_82549_(pos);
        this.update();
    }

    @Override
    public Vec3 getPos() {
        return this.pos;
    }

    public float getRotX() {
        return this.rotX;
    }

    public float getRotY() {
        return this.rotY;
    }

    public float getRotZ() {
        return this.rotZ;
    }

    public void rotate(float rotX, float rotY, float rotZ) {
        this.rotX += rotX;
        this.rotY += rotY;
        this.rotZ += rotZ;
        this.update();
    }

    public void setRotation(float rotX, float rotY, float rotZ) {
        this.rotX = rotX;
        this.rotY = rotY;
        this.rotZ = rotZ;
        this.update();
    }

    private void update() {
        this.verts[0] = new Vec3(this.aabb.f_82288_, this.aabb.f_82289_, this.aabb.f_82290_);
        this.verts[1] = new Vec3(this.aabb.f_82288_, this.aabb.f_82289_, this.aabb.f_82293_);
        this.verts[2] = new Vec3(this.aabb.f_82288_, this.aabb.f_82292_, this.aabb.f_82290_);
        this.verts[3] = new Vec3(this.aabb.f_82288_, this.aabb.f_82292_, this.aabb.f_82293_);
        this.verts[4] = new Vec3(this.aabb.f_82291_, this.aabb.f_82289_, this.aabb.f_82290_);
        this.verts[5] = new Vec3(this.aabb.f_82291_, this.aabb.f_82289_, this.aabb.f_82293_);
        this.verts[6] = new Vec3(this.aabb.f_82291_, this.aabb.f_82292_, this.aabb.f_82290_);
        this.verts[7] = new Vec3(this.aabb.f_82291_, this.aabb.f_82292_, this.aabb.f_82293_);
        double cosA = Math.cos(Math.toRadians(this.rotZ));
        double sinA = Math.sin(Math.toRadians(this.rotZ));
        double cosB = Math.cos(Math.toRadians(this.rotY));
        double sinB = Math.sin(Math.toRadians(this.rotY));
        double cosC = Math.cos(Math.toRadians(this.rotX));
        double sinC = Math.sin(Math.toRadians(this.rotX));
        double Axx = cosA * cosB;
        double Axy = cosA * sinB * sinC - sinA * cosC;
        double Axz = cosA * sinB * cosC + sinA * sinC;
        double Ayx = sinA * cosB;
        double Ayy = sinA * sinB * sinC + cosA * cosC;
        double Ayz = sinA * sinB * cosC - cosA * sinC;
        double Azx = -sinB;
        double Azy = cosB * sinC;
        double Azz = cosB * cosC;
        for (int i = 0; i < 8; ++i) {
            Vec3 p = this.verts[i];
            this.verts[i] = new Vec3(Axx * p.f_82479_ + Axy * p.f_82480_ + Axz * p.f_82481_ + this.pos.f_82479_, Ayx * p.f_82479_ + Ayy * p.f_82480_ + Ayz * p.f_82481_ + this.pos.f_82480_, Azx * p.f_82479_ + Azy * p.f_82480_ + Azz * p.f_82481_ + this.pos.f_82481_);
        }
        this.axes[0] = this.verts[0].m_82546_(this.verts[1]).m_82541_();
        this.axes[1] = this.verts[0].m_82546_(this.verts[2]).m_82541_();
        this.axes[2] = this.verts[0].m_82546_(this.verts[4]).m_82541_();
    }

    @Override
    public Vec3[] getAxes() {
        return this.axes;
    }

    @Override
    public Vec3[] getVerts() {
        return this.verts;
    }
}

