/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.experimental_features.fixed_data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;

public class BlockPropertyLoader {
    private static final Map<String, BlockBehaviour.Properties> PROPERTIES = new HashMap<String, BlockBehaviour.Properties>();

    public static BlockBehaviour.Properties getProp(String name) {
        if (PROPERTIES.isEmpty()) {
            BlockPropertyLoader.loadBlockProperties();
        }
        return PROPERTIES.get(name);
    }

    public static void loadBlockProperties() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(BlockPropertyLoader.class.getClassLoader().getResourceAsStream("fixed_data/projectbrazier/item_props.json")));){
            JsonParser parser = new JsonParser();
            JsonObject properties = parser.parse((Reader)reader).getAsJsonObject();
            for (Map.Entry entry : properties.entrySet()) {
                PROPERTIES.put((String)entry.getKey(), BlockPropertyLoader.loadProp((JsonObject)entry.getValue()));
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private static BlockBehaviour.Properties loadProp(JsonObject propObj) {
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.m_60939_((Material)BlockPropertyLoader.getMaterialFromName(GsonHelper.m_13851_((JsonObject)propObj, (String)"material", (String)"AIR")));
        if (GsonHelper.m_13855_((JsonObject)propObj, (String)"hasCollision", (boolean)true)) {
            prop.m_60910_();
        }
        if (GsonHelper.m_13855_((JsonObject)propObj, (String)"hasOcclusion", (boolean)true)) {
            prop.m_60955_();
        }
        prop.m_60911_(GsonHelper.m_13820_((JsonObject)propObj, (String)"friction", (float)0.6f));
        prop.m_60956_(GsonHelper.m_13820_((JsonObject)propObj, (String)"speedFactor", (float)1.0f));
        prop.m_60967_(GsonHelper.m_13820_((JsonObject)propObj, (String)"jumpFactor", (float)1.0f));
        return prop;
    }

    private static FoodProperties loadFood(JsonObject foodObj) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(GsonHelper.m_13927_((JsonObject)foodObj, (String)"Hunger"));
        builder.m_38758_(GsonHelper.m_13915_((JsonObject)foodObj, (String)"Saturation"));
        if (GsonHelper.m_13855_((JsonObject)foodObj, (String)"IsMeat", (boolean)false)) {
            builder.m_38757_();
        }
        if (GsonHelper.m_13855_((JsonObject)foodObj, (String)"FastEat", (boolean)false)) {
            builder.m_38766_();
        }
        if (GsonHelper.m_13855_((JsonObject)foodObj, (String)"AlwaysEdible", (boolean)false)) {
            builder.m_38765_();
        }
        return builder.m_38767_();
    }

    private static Material getMaterialFromName(String name) {
        switch (name.toUpperCase()) {
            case "AIR": {
                return Material.f_76296_;
            }
            case "STRUCTURE_VOID": {
                return Material.f_76297_;
            }
            case "PORTAL": {
                return Material.f_76298_;
            }
            case "CARPET": {
                return Material.f_76299_;
            }
            case "PLANTS": {
                return Material.f_76300_;
            }
            case "OCEAN_PLANT": {
                return Material.f_76301_;
            }
            case "TALL_PLANTS": {
                return Material.f_76302_;
            }
            case "REPLACEABLE_FIREPROOF_PLANT": {
                return Material.f_76303_;
            }
            case "SEA_GRASS": {
                return Material.f_76304_;
            }
            case "WATER": {
                return Material.f_76305_;
            }
            case "BUBBLE_COLUMN": {
                return Material.f_76306_;
            }
            case "LAVA": {
                return Material.f_76307_;
            }
            case "SNOW": {
                return Material.f_76308_;
            }
            case "FIRE": {
                return Material.f_76309_;
            }
            case "WEB": {
                return Material.f_76311_;
            }
            case "SCULK": {
                return Material.f_164533_;
            }
            case "REDSTONE_LIGHT": {
                return Material.f_76312_;
            }
            case "CLAY": {
                return Material.f_76313_;
            }
            case "EARTH": {
                return Material.f_76314_;
            }
            case "ORGANIC": {
                return Material.f_76315_;
            }
            case "PACKED_ICE": {
                return Material.f_76316_;
            }
            case "SAND": {
                return Material.f_76317_;
            }
            case "SPONGE": {
                return Material.f_76318_;
            }
            case "SHULKER": {
                return Material.f_76319_;
            }
            case "WOOD": {
                return Material.f_76320_;
            }
            case "NETHER_WOOD": {
                return Material.f_76321_;
            }
            case "BAMBOO_SAPLING": {
                return Material.f_76270_;
            }
            case "BAMBOO": {
                return Material.f_76271_;
            }
            case "WOOL": {
                return Material.f_76272_;
            }
            case "TNT": {
                return Material.f_76273_;
            }
            case "LEAVES": {
                return Material.f_76274_;
            }
            case "GLASS": {
                return Material.f_76275_;
            }
            case "ICE": {
                return Material.f_76276_;
            }
            case "CACTUS": {
                return Material.f_76277_;
            }
            case "ROCK": {
                return Material.f_76278_;
            }
            case "IRON": {
                return Material.f_76279_;
            }
            case "SNOW_BLOCK": {
                return Material.f_76280_;
            }
            case "ANVIL": {
                return Material.f_76281_;
            }
            case "BARRIER": {
                return Material.f_76282_;
            }
            case "PISTON": {
                return Material.f_76283_;
            }
            case "MOSS": {
                return Material.f_164530_;
            }
            case "GOURD": {
                return Material.f_76285_;
            }
            case "DRAGON_EGG": {
                return Material.f_76286_;
            }
            case "CAKE": {
                return Material.f_76287_;
            }
            case "AMETHYST": {
                return Material.f_164531_;
            }
            case "POWDER_SNOW": {
                return Material.f_164532_;
            }
        }
        return Material.f_76310_;
    }
}

