/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.experimental_features.fixed_data;

import com.google.common.base.Joiner;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;

public class FixedDataPack {
    private static Map<String, FixedDataPack> FIXED_DATA_PACKS = new HashMap<String, FixedDataPack>();
    private final IModFile file;

    @Nullable
    public static FixedDataPack getPackForMod(String modid) {
        return FIXED_DATA_PACKS.computeIfAbsent(modid, key -> {
            Optional mod = ModList.get().getModContainerById(key);
            if (!mod.isPresent()) {
                return null;
            }
            IModFileInfo file = ((ModContainer)mod.get()).getModInfo().getOwningFile();
            return new FixedDataPack(file.getFile());
        });
    }

    public FixedDataPack(IModFile file) {
        this.file = file;
    }

    public Collection<ResourceLocation> getResources(String resourceNamespace, String pathIn, int maxDepth, Predicate<String> filter) {
        try {
            Path root = this.resolve("fixed_data", resourceNamespace).toAbsolutePath();
            Path inputPath = root.getFileSystem().getPath(pathIn, new String[0]);
            return Files.walk(root, new FileVisitOption[0]).map(root::relativize).filter(path -> path.getNameCount() <= maxDepth && !path.toString().endsWith(".mcmeta") && path.startsWith(inputPath)).filter(path -> filter.test(path.getFileName().toString())).map(path -> new ResourceLocation(resourceNamespace, Joiner.on((char)'/').join((Iterable)path))).collect(Collectors.toList());
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    protected InputStream getResource(String name) throws IOException {
        Path path = this.resolve(name);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("Can't find resource " + name + " at " + this.file.getFileName());
        }
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    public InputStream getResource(ResourceLocation location) throws IOException {
        return this.getResource("fixed_data/" + location.m_135827_() + "/" + location.m_135815_());
    }

    protected Path resolve(String ... paths) {
        return this.file.findResource(paths);
    }
}

