/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.experimental_features.fixed_data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierCreativeTabs;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;

public class ItemPropertyLoader {
    private static final Map<String, Item.Properties> PROPERTIES = new HashMap<String, Item.Properties>();

    public static Item.Properties getProp(String name) {
        if (PROPERTIES.isEmpty()) {
            ItemPropertyLoader.loadItemProperties();
        }
        return PROPERTIES.get(name);
    }

    public static void loadItemProperties() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(ItemPropertyLoader.class.getClassLoader().getResourceAsStream("fixed_data/projectbrazier/item_props.json")));){
            JsonParser parser = new JsonParser();
            JsonObject properties = parser.parse((Reader)reader).getAsJsonObject();
            for (Map.Entry entry : properties.entrySet()) {
                PROPERTIES.put((String)entry.getKey(), ItemPropertyLoader.loadProp((JsonObject)entry.getValue()));
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public static void loadItemProperties(InputStream input) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            JsonParser parser = new JsonParser();
            JsonObject properties = parser.parse((Reader)reader).getAsJsonObject();
            for (Map.Entry entry : properties.entrySet()) {
                PROPERTIES.put((String)entry.getKey(), ItemPropertyLoader.loadProp((JsonObject)entry.getValue()));
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public static Item.Properties loadProp(JsonObject propObj) {
        Item.Properties prop = new Item.Properties();
        prop.m_41487_(GsonHelper.m_13824_((JsonObject)propObj, (String)"MaxCount", (int)64));
        if (propObj.has("MaxDamage")) {
            prop.m_41503_(GsonHelper.m_13927_((JsonObject)propObj, (String)"MaxDamage"));
        }
        if (propObj.has("ItemGroup")) {
            prop.m_41491_(BrazierCreativeTabs.getGroupFromName(GsonHelper.m_13906_((JsonObject)propObj, (String)"ItemGroup")));
        }
        if (propObj.has("Food")) {
            prop.m_41489_(ItemPropertyLoader.loadFood(GsonHelper.m_13930_((JsonObject)propObj, (String)"Food")));
        }
        return prop;
    }

    private static FoodProperties loadFood(JsonObject foodObj) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(GsonHelper.m_13927_((JsonObject)foodObj, (String)"Hunger"));
        builder.m_38758_(GsonHelper.m_13915_((JsonObject)foodObj, (String)"Saturation"));
        if (GsonHelper.m_13855_((JsonObject)foodObj, (String)"IsMeat", (boolean)false)) {
            builder.m_38757_();
        }
        if (GsonHelper.m_13855_((JsonObject)foodObj, (String)"FastEat", (boolean)false)) {
            builder.m_38766_();
        }
        if (GsonHelper.m_13855_((JsonObject)foodObj, (String)"AlwaysEdible", (boolean)false)) {
            builder.m_38765_();
        }
        return builder.m_38767_();
    }
}

