/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.blockentities;

import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.dark_roleplay.projectbrazier.feature.helpers.ZiplineHelper;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierBlockEntities;
import net.dark_roleplay.projectbrazier.util.data.NBTUtil2;
import net.dark_roleplay.projectbrazier.util.math.bezier.BezierCurve;
import net.dark_roleplay.projectbrazier.util.math.vector.VectorUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ZiplineBlockEntity
extends BlockEntity {
    private BezierCurve curve;
    private Vector3f start;
    private Vector3f mid;
    private Vector3f end;
    private Vector3f[] vertices = null;

    public ZiplineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BrazierBlockEntities.ZIPLINE_ANCHOR.get(), pos, state);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.start == null || this.end == null) {
            return;
        }
        compound.m_128365_("start", (Tag)NBTUtil2.writeVector3f(this.start));
        compound.m_128365_("end", (Tag)NBTUtil2.writeVector3f(this.end));
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (!compound.m_128441_("start")) {
            return;
        }
        this.setPositions(NBTUtil2.readVector3f(compound.m_128469_("start")), NBTUtil2.readVector3f(compound.m_128469_("end")), true);
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void setPositions(Vector3f start, Vector3f end, boolean isLoading) {
        this.start = start.m_122281_();
        this.end = end.m_122281_();
        this.mid = VectorUtils.lerpVector(start, end, 0.6);
        float yDist = this.start.m_122260_() - this.end.m_122260_();
        float xDist = this.start.m_122239_() - this.end.m_122239_();
        float zDist = this.start.m_122269_() - this.end.m_122269_();
        float distance = (float)Math.sqrt(yDist * yDist + xDist * xDist + zDist * zDist);
        this.mid.setY(this.mid.m_122260_() - Math.min(yDist * 0.4f, 7.0f));
        this.curve = BezierCurve.createGlobal(this.start, this.mid, this.end, (int)distance);
        if (!isLoading) {
            this.m_6596_();
        }
    }

    public void setPositionInitial(Vector3f start, Vector3f mid, Vector3f end, BezierCurve curve) {
        this.start = start.m_122281_();
        this.mid = mid.m_122281_();
        this.end = end.m_122281_();
        this.curve = curve;
        this.m_6596_();
    }

    public void startPlayerZipline(Player player) {
        ZiplineHelper.startZipline((Entity)player, this.m_58904_(), this.start, this.end, this.mid);
    }

    public boolean isInitialized() {
        return this.start != null;
    }

    public Vector3f[] getVertices() {
        if (this.vertices != null) {
            return this.vertices;
        }
        if (this.isInitialized()) {
            BezierCurve[] curves = new BezierCurve[]{this.curve.offset(-0.0625f, -0.0625f), this.curve.offset(-0.0625f, 0.0625f), this.curve.offset(0.0625f, 0.0625f), this.curve.offset(0.0625f, -0.0625f)};
            Vector3f[] bezierPoints = this.curve.getBezierPoints();
            Vector3f[][] bezierPoints2 = new Vector3f[][]{curves[0].getBezierPoints(), curves[1].getBezierPoints(), curves[2].getBezierPoints(), curves[3].getBezierPoints()};
            this.vertices = new Vector3f[bezierPoints.length * 4];
            for (int i = 0; i < bezierPoints.length; ++i) {
                this.vertices[i * 4] = bezierPoints2[0][i];
                this.vertices[i * 4 + 1] = bezierPoints2[1][i];
                this.vertices[i * 4 + 2] = bezierPoints2[2][i];
                this.vertices[i * 4 + 3] = bezierPoints2[3][i];
            }
            return this.vertices;
        }
        return null;
    }
}

