/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.blocks;

import java.util.List;
import java.util.Optional;
import net.dark_roleplay.marg.common.material.MargMaterial;
import net.dark_roleplay.projectbrazier.feature.blockentities.BarrelBlockEntity;
import net.dark_roleplay.projectbrazier.feature.blocks.BarrelStorageType;
import net.dark_roleplay.projectbrazier.feature.blocks.templates.DecoBlock;
import net.dark_roleplay.projectbrazier.util.capabilities.ItemHandlerUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BarrelBlock
extends DecoBlock
implements EntityBlock {
    private boolean isClosed;
    private Block otherBlock;
    private MargMaterial material;
    private Item plankItem;
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");

    public BarrelBlock(MargMaterial material, BlockBehaviour.Properties properties, String voxelShape, boolean isClosed) {
        super(properties, voxelShape);
        this.isClosed = isClosed;
        this.material = material;
    }

    public void setOtherBlock(Block block) {
        this.otherBlock = block;
    }

    public void m_5871_(ItemStack p_49816_, @Nullable BlockGetter p_49817_, List<Component> lines, TooltipFlag flag) {
        if (!this.isClosed) {
            lines.add((Component)new TranslatableComponent("block.info.projectbrazier.barrel").m_130940_(ChatFormatting.GRAY));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.isClosed) {
            if (player.m_6144_()) {
                return this.openBarrel(state, world, pos, player, hand, hit);
            }
        } else {
            LazyOptional fluidCap;
            boolean success;
            InteractionResult closingResult = this.closeBarrel(state, world, pos, player, hand, hit);
            if (closingResult.m_19080_()) {
                return closingResult;
            }
            BlockEntity tileEntity = world.m_7702_(pos);
            if (!(tileEntity instanceof BarrelBlockEntity)) {
                return InteractionResult.FAIL;
            }
            BarrelBlockEntity tileEntityBarrel = (BarrelBlockEntity)tileEntity;
            BarrelStorageType type = tileEntityBarrel.getStorageType();
            if ((type == BarrelStorageType.FLUID || type == BarrelStorageType.NONE) && (success = (fluidCap = tileEntityBarrel.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).map(fluidHandler -> {
                Optional fluid = FluidUtil.getFluidContained((ItemStack)player.m_21120_(hand));
                FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)player.m_21120_(hand), (IFluidHandler)fluidHandler, (int)16000, (Player)player, (boolean)true);
                if (result.isSuccess()) {
                    if (((FluidStack)fluid.get()).getFluid().getAttributes().getTemperature((FluidStack)fluid.get()) > 555) {
                        world.m_7740_(pos, false, (Entity)player, 0);
                        world.m_46597_(pos, ((FluidStack)fluid.get()).getFluid().m_76145_().m_76188_());
                    }
                    if (!player.m_7500_()) {
                        player.m_21008_(hand, result.getResult());
                    }
                    return true;
                }
                ItemStack stack = player.m_21120_(hand);
                result = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)fluidHandler, (int)16000, (Player)player, (boolean)true);
                if (result.isSuccess()) {
                    if (!player.m_7500_()) {
                        if (player.m_21120_(hand).m_41613_() == 1) {
                            player.m_21008_(hand, result.getResult());
                        } else {
                            stack.m_41774_(1);
                            player.m_36176_(result.getResult(), true);
                        }
                    }
                    return true;
                }
                return false;
            }).orElse(false).booleanValue())) {
                return InteractionResult.SUCCESS;
            }
            if (type == BarrelStorageType.ITEMS || type == BarrelStorageType.NONE) {
                LazyOptional invCap = tileEntityBarrel.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)tileEntity), (BlockPos)pos);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private InteractionResult openBarrel(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.isClosed) {
            return InteractionResult.PASS;
        }
        world.m_46597_(pos, this.otherBlock.m_49966_());
        world.m_5594_(null, pos, this.getSoundType(state, (LevelReader)world, pos, null).m_56775_(), SoundSource.BLOCKS, 2.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult closeBarrel(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem;
        if (this.isClosed) {
            return InteractionResult.PASS;
        }
        if (this.plankItem == null) {
            String plankItemName = (String)this.material.getItems().get("planks");
            if (plankItemName == null) {
                return InteractionResult.PASS;
            }
            this.plankItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(plankItemName));
            if (this.plankItem == null) {
                this.plankItem = Items.f_41829_;
            }
        }
        if ((heldItem = player.m_21120_(hand)).m_41720_() == this.plankItem) {
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
            }
            world.m_46597_(pos, this.otherBlock.m_49966_());
            world.m_5594_(null, pos, this.getSoundType(state, (LevelReader)world, pos, null).m_56777_(), SoundSource.BLOCKS, 2.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && entity.m_6060_() && (blockEntity = level.m_7702_(pos)) instanceof BarrelBlockEntity) {
            BarrelBlockEntity be = (BarrelBlockEntity)blockEntity;
            be.handleEntity(state, pos, entity);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && (newState.m_60734_() != this && newState.m_60734_() != this.otherBlock || !newState.m_155947_())) {
            if (!this.isClosed) {
                ItemHandlerUtil.dropContainerItems(world, pos);
            }
            world.m_46747_(pos);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BarrelBlockEntity(pos, state);
    }
}

