/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.blocks;

import net.dark_roleplay.projectbrazier.feature.blocks.RopeBlock;
import net.dark_roleplay.projectbrazier.feature.blocks.templates.HFacedDecoBlock;
import net.dark_roleplay.projectbrazier.feature.mechanics.tertiary_interactions.ITertiaryInteractor;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierBlocks;
import net.dark_roleplay.projectbrazier.util.blocks.HFacedVoxelShape;
import net.dark_roleplay.projectbrazier.util.json.VoxelShapeLoader;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RopeAnchorBlock
extends HFacedDecoBlock
implements ITertiaryInteractor {
    private static int maxLength = 36;
    protected final HFacedVoxelShape droppedShapes;
    public static final BooleanProperty IS_DROPPED = BooleanProperty.m_61465_((String)"dropped");

    public RopeAnchorBlock(BlockBehaviour.Properties props, String shapeName, String droppedShape) {
        super(props, shapeName);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)IS_DROPPED, (Comparable)Boolean.valueOf(false)));
        this.droppedShapes = new HFacedVoxelShape(VoxelShapeLoader.getVoxelShape(droppedShape));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)IS_DROPPED) != false ? this.droppedShapes.get((Direction)state.m_61143_((Property)HORIZONTAL_FACING)) : this.shapes.get((Direction)state.m_61143_((Property)HORIZONTAL_FACING));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{IS_DROPPED});
    }

    @Override
    public boolean hasInteraction(BlockGetter world, BlockPos pos, BlockState state, Player palyer) {
        return true;
    }

    @Override
    public void executeInteraction(Level world, BlockPos pos, BlockState state, Player player) {
        boolean isDropped = (Boolean)state.m_61143_((Property)IS_DROPPED);
        if (isDropped) {
            this.pullUpRope(world, pos, state, player);
        } else if (!this.dropDownRope(world, pos, state, player.m_20186_() + 1.0 < (double)pos.m_123342_() ? player.m_6350_().m_122424_() : player.m_6350_())) {
            this.dropDownRope(world, pos, state, player.m_20186_() + 1.0 < (double)pos.m_123342_() ? player.m_6350_() : player.m_6350_().m_122424_());
        }
    }

    @Override
    public Component getInteractionTooltip(Level world, BlockPos pos, BlockState state, Player player) {
        return (Boolean)state.m_61143_((Property)IS_DROPPED) != false ? new TranslatableComponent("interaction.projectbrazier.rope_anchor.pull_up") : new TranslatableComponent("interaction.projectbrazier.rope_anchor.drop");
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block otherBlock, BlockPos otherPos, boolean p_55671_) {
        if (!world.f_46443_ && world.m_46753_(pos) && !((Boolean)state.m_61143_((Property)IS_DROPPED)).booleanValue()) {
            this.dropDownRope(world, pos, state, (Direction)state.m_61143_((Property)HORIZONTAL_FACING));
        }
    }

    private boolean pullUpRope(Level world, BlockPos pos, BlockState state, Player player) {
        boolean isDropped = (Boolean)state.m_61143_((Property)IS_DROPPED);
        if (!isDropped) {
            return false;
        }
        Direction dir = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
        BlockPos.MutableBlockPos iterPos = pos.m_122032_();
        iterPos.m_122173_(dir).m_122173_(Direction.DOWN);
        BlockState targetState = world.m_8055_((BlockPos)iterPos);
        while (targetState.m_60734_() == BrazierBlocks.ROPE.get() && targetState.m_61143_((Property)HORIZONTAL_FACING) == dir) {
            iterPos.m_122184_(0, -1, 0);
            targetState = world.m_8055_((BlockPos)iterPos);
        }
        iterPos.m_122184_(0, 1, 0);
        if (world.m_6249_((Entity)player, new AABB(pos, (BlockPos)iterPos).m_82363_(0.5, 0.5, 0.5), otherMob -> otherMob instanceof LivingEntity).size() > 0) {
            if (player != null) {
                player.m_5661_((Component)new TranslatableComponent("interaction.projectbrazier.rope_anchor.pull_up_fail").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return false;
        }
        while (iterPos.m_123342_() < pos.m_123342_()) {
            world.m_46597_((BlockPos)iterPos, Blocks.f_50016_.m_49966_());
            iterPos.m_122184_(0, 1, 0);
        }
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)IS_DROPPED, (Comparable)Boolean.valueOf(false)));
        return true;
    }

    private boolean dropDownRope(Level world, BlockPos pos, BlockState state, Direction dir) {
        boolean isDropped = (Boolean)state.m_61143_((Property)IS_DROPPED);
        if (isDropped) {
            return false;
        }
        BlockState ropeState = (BlockState)((BlockState)((Block)BrazierBlocks.ROPE.get()).m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)dir)).m_61124_((Property)RopeBlock.IS_END, (Comparable)Boolean.valueOf(false));
        BlockPos.MutableBlockPos iterPos = pos.m_122032_();
        iterPos.m_122173_(dir).m_122173_(Direction.DOWN);
        for (int i = 0; i < maxLength; ++i) {
            BlockState targetState = world.m_8055_((BlockPos)iterPos);
            if (!targetState.m_60795_()) {
                if (i != 0) break;
                return false;
            }
            world.m_46597_((BlockPos)iterPos, ropeState);
            iterPos.m_122184_(0, -1, 0);
            if (iterPos.m_123342_() < world.m_141937_()) break;
        }
        iterPos.m_122184_(0, 1, 0);
        world.m_46597_((BlockPos)iterPos, (BlockState)ropeState.m_61124_((Property)RopeBlock.IS_END, (Comparable)Boolean.valueOf(true)));
        world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)IS_DROPPED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)dir));
        return true;
    }

    @Override
    public int getDurationInMS(Level world, BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)IS_DROPPED) != false ? 750 : 500;
    }
}

