/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature.helpers;

import java.util.Iterator;
import java.util.List;
import net.dark_roleplay.projectbrazier.feature.entities.SittableEntity;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierEntities;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SittingHelper {
    public static boolean sitOnBlock(Level world, Vec3i pos, Entity entity, double heightOffset, BlockState state) {
        return SittingHelper.sitDownEntity(world, new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), entity, null, null, heightOffset, state);
    }

    public static boolean sitOnBlockWithRotation(Level world, Vec3i pos, Entity entity, Direction facing, double heightOffset, BlockState state) {
        return SittingHelper.sitDownEntity(world, new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), entity, facing, null, heightOffset, state);
    }

    public static boolean sitOnBlock(Level world, Vec3i pos, Entity entity, Direction initFacing, double heightOffset, BlockState state) {
        return SittingHelper.sitDownEntity(world, new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), entity, null, initFacing, heightOffset, state);
    }

    public static boolean sitOnBlockWithRotation(Level world, Vec3i pos, Entity entity, Direction facing, Direction initFacing, double heightOffset, BlockState state) {
        return SittingHelper.sitDownEntity(world, new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), entity, facing, initFacing, heightOffset, state);
    }

    public static boolean sitDownEntity(Level world, Vec3 pos, Entity entity, Direction facing, Direction initFacing, double heightOffset, BlockState state) {
        if (state != null && entity instanceof Player) {
            Vec3 vec3 = new Vec3(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            if (entity.m_20182_().m_82557_(vec3) > 9.0) {
                if (world.m_5776_()) {
                    ((Player)entity).m_5661_((Component)new TranslatableComponent("interaction.projectbrazier.chair_to_far", new Object[]{state.m_60734_().m_49954_()}), true);
                }
                return false;
            }
            if (SittingHelper.isSomeoneSitting(world, pos)) {
                if (world.m_5776_()) {
                    ((Player)entity).m_5661_((Component)new TranslatableComponent("interaction.projectbrazier.chair_occupied", new Object[]{state.m_60734_().m_49954_()}), true);
                }
                return false;
            }
        }
        if (world.m_5776_()) {
            return false;
        }
        SittableEntity chairEntity = new SittableEntity((EntityType<SittableEntity>)((EntityType)BrazierEntities.SITTABLE.get()), world, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), heightOffset, state != null);
        if (facing != null) {
            chairEntity.setRotation(facing);
        }
        if (initFacing != null) {
            entity.f_19859_ = initFacing.m_122435_();
            entity.m_146922_(initFacing.m_122435_());
        }
        ((ServerLevel)world).m_8847_((Entity)chairEntity);
        entity.m_20329_((Entity)chairEntity);
        return true;
    }

    public static boolean isSomeoneSitting(Level world, Vec3 pos) {
        List listEMB = world.m_45976_(SittableEntity.class, new AABB((double)((int)pos.m_7096_()), (double)((int)pos.m_7098_()), (double)((int)pos.m_7094_()), (double)((int)pos.m_7096_()) + 1.0, (double)((int)pos.m_7098_()) + 1.0, (double)((int)pos.m_7094_()) + 1.0));
        Iterator iterator = listEMB.iterator();
        if (iterator.hasNext()) {
            SittableEntity mount = (SittableEntity)((Object)iterator.next());
            return mount.m_20160_();
        }
        return false;
    }
}

