/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature_client.blocks;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dark_roleplay.projectbrazier.experimental_features.builtin_mixed_model.IQuadProvider;
import net.dark_roleplay.projectbrazier.feature.blocks.FlowerContainerData;
import net.dark_roleplay.projectbrazier.feature_client.listeners.ResourceReloadUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class CFlowerContainerData
extends FlowerContainerData
implements IQuadProvider {
    private EnumMap<Direction, List<BakedQuad>> quads;
    private List<BakedQuad> nullQuads;

    public CFlowerContainerData() {
        ResourceReloadUtil.addReloadListener(this, () -> {
            this.quads = null;
        });
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.quads = null;
        this.nullQuads = null;
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState teState, @Nullable Direction side, @Nonnull Random rand) {
        if (this.flower.m_41619_()) {
            return null;
        }
        if (this.quads == null) {
            Item item = this.flower.m_41720_();
            if (!(item instanceof BlockItem)) {
                return new ArrayList<BakedQuad>();
            }
            this.quads = new EnumMap(Direction.class);
            this.nullQuads = new ArrayList<BakedQuad>();
            BlockItem block = (BlockItem)item;
            BlockState[] states = new BlockState[]{block.m_40614_().m_49966_(), null};
            Vec3i offset = this.placement;
            if (states[0].m_61138_((Property)BlockStateProperties.f_61401_)) {
                DoubleBlockHalf sourceHalf = (DoubleBlockHalf)states[0].m_61143_((Property)BlockStateProperties.f_61401_);
                states[1] = (BlockState)states[0].m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)(sourceHalf == DoubleBlockHalf.LOWER ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER));
            }
            BlockRenderDispatcher blockrendererdispatcher = Minecraft.m_91087_().m_91289_();
            for (BlockState state : states) {
                if (state == null) continue;
                BakedModel cachedModel = blockrendererdispatcher.m_110910_(state);
                for (Direction dir : Direction.values()) {
                    List facedQuads = this.quads.computeIfAbsent(dir, key -> new ArrayList());
                    List quads = cachedModel.m_6840_(state, side, rand);
                    for (BakedQuad quad : quads) {
                        facedQuads.add(this.translateQuad(quad, offset));
                    }
                }
                List quads = cachedModel.m_6840_(state, null, rand);
                for (BakedQuad quad : quads) {
                    this.nullQuads.add(this.translateQuad(quad, offset));
                }
                offset = offset.m_6630_(16);
            }
        }
        if (side == null) {
            return this.nullQuads;
        }
        return this.quads.get(side);
    }

    private BakedQuad translateQuad(BakedQuad quad, Vec3i offset) {
        int[] vertexData = quad.m_111303_();
        int[] newVertexData = new int[vertexData.length];
        VertexFormat format = DefaultVertexFormat.f_85811_;
        float offsetX = (float)offset.m_123341_() * 0.0625f - 0.5f + 0.03125f;
        float offsetY = (float)offset.m_123342_() * 0.0625f;
        float offsetZ = (float)offset.m_123343_() * 0.0625f - 0.5f + 0.03125f;
        for (int i = 0; i < vertexData.length; i += format.m_86017_()) {
            newVertexData[i] = Float.floatToIntBits(Float.intBitsToFloat(vertexData[i]) + offsetX);
            newVertexData[i + 1] = Float.floatToIntBits(Float.intBitsToFloat(vertexData[i + 1]) + offsetY);
            newVertexData[i + 2] = Float.floatToIntBits(Float.intBitsToFloat(vertexData[i + 2]) + offsetZ);
            for (int j = 3; j < format.m_86017_() - 1; ++j) {
                newVertexData[i + j] = vertexData[i + j];
            }
        }
        return new BakedQuad(newVertexData, quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), false);
    }
}

