/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature_client.model_loaders.axis_connected_models;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public enum AxisConnectionType {
    DEFAULT(false, false),
    POSITIVE(true, false),
    NEGATIVE(false, true),
    CENTERED(true, true);

    private final boolean isPositive;
    private final boolean isNegative;

    private AxisConnectionType(boolean isPositive, boolean isNegative) {
        this.isPositive = isPositive;
        this.isNegative = isNegative;
    }

    public AxisConnectionType addPositive() {
        if (this == DEFAULT) {
            return POSITIVE;
        }
        if (this == NEGATIVE) {
            return CENTERED;
        }
        return this;
    }

    public AxisConnectionType addNegative() {
        if (this == DEFAULT) {
            return NEGATIVE;
        }
        if (this == POSITIVE) {
            return CENTERED;
        }
        return this;
    }

    public boolean isPositive() {
        return this.isPositive;
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public static AxisConnectionType getConnections(@Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        boolean flag = false;
        flag = state.m_61138_((Property)BlockStateProperties.f_61364_);
        if (flag || state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            Direction.Axis axis = flag ? (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61364_) : (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
            return AxisConnectionType.getConnections(world, pos, state, axis);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            return AxisConnectionType.getConnections(world, pos, state, (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
        }
        return DEFAULT;
    }

    public static AxisConnectionType getConnections(@Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, Direction.Axis axis) {
        AxisConnectionType type = DEFAULT;
        switch (axis) {
            case X: {
                if (world.m_8055_(pos.m_142126_()) == state) {
                    type = type.addPositive();
                }
                if (world.m_8055_(pos.m_142125_()) != state) break;
                type = type.addNegative();
                break;
            }
            case Y: {
                if (world.m_8055_(pos.m_7494_()) == state) {
                    type = type.addPositive();
                }
                if (world.m_8055_(pos.m_7495_()) != state) break;
                type = type.addNegative();
                break;
            }
            case Z: {
                if (world.m_8055_(pos.m_142128_()) == state) {
                    type = type.addPositive();
                }
                if (world.m_8055_(pos.m_142127_()) != state) break;
                type = type.addNegative();
            }
        }
        return type;
    }

    public static AxisConnectionType getConnections(@Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, Direction facing) {
        AxisConnectionType type = DEFAULT;
        Direction.Axis axis = facing.m_122427_().m_122434_();
        switch (axis) {
            case X: {
                if (world.m_8055_(pos.m_142126_()) == state) {
                    type = type.addPositive();
                }
                if (world.m_8055_(pos.m_142125_()) != state) break;
                type = type.addNegative();
                break;
            }
            case Y: {
                if (world.m_8055_(pos.m_7494_()) == state) {
                    type = type.addPositive();
                }
                if (world.m_8055_(pos.m_7495_()) != state) break;
                type = type.addNegative();
                break;
            }
            case Z: {
                if (world.m_8055_(pos.m_142128_()) == state) {
                    type = type.addPositive();
                }
                if (world.m_8055_(pos.m_142127_()) != state) break;
                type = type.addNegative();
            }
        }
        return type;
    }
}

