/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature_client.model_loaders.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public abstract class AdvancedModelBox {
    protected Vector3f pos;
    protected Vector3f size;
    protected TextureAtlasSprite sprite;
    protected Vector3f[] vertices;

    public AdvancedModelBox(Vector3f pos, Vector3f size, Vector3f offset, Matrix4f matrix, TextureAtlasSprite sprite) {
        this.pos = pos;
        this.size = size;
        this.sprite = sprite;
        this.vertices = new Vector3f[8];
        float x = pos.m_122239_();
        float x2 = pos.m_122239_() + size.m_122239_();
        float y = pos.m_122260_();
        float y2 = pos.m_122260_() + size.m_122260_();
        float z = pos.m_122269_();
        float z2 = pos.m_122269_() + size.m_122269_();
        Vector4f[] tmpVectors = new Vector4f[]{new Vector4f(x, y, z, 1.0f), new Vector4f(x2, y, z, 1.0f), new Vector4f(x2, y, z2, 1.0f), new Vector4f(x, y, z2, 1.0f), new Vector4f(x, y2, z, 1.0f), new Vector4f(x2, y2, z, 1.0f), new Vector4f(x2, y2, z2, 1.0f), new Vector4f(x, y2, z2, 1.0f)};
        for (int i = 0; i < 8; ++i) {
            Vector4f tmp = tmpVectors[i];
            tmp.m_123607_(matrix);
            this.vertices[i] = new Vector3f(tmp.m_123601_() + offset.m_122239_(), tmp.m_123615_() + offset.m_122260_(), tmp.m_123616_() + offset.m_122269_());
        }
    }

    public abstract BakedQuad[] bake();

    protected int[] generateVertexData(float u1, float v1, float u2, float v2, Vector3f ... vertices) {
        int[] data = new int[DefaultVertexFormat.f_85811_.m_86017_() * vertices.length];
        int offset = 0;
        Vector3f normalVec = vertices[1].m_122281_();
        Vector3f vecB = vertices[2].m_122281_();
        normalVec.m_122267_(vertices[0]);
        vecB.m_122267_(vertices[0]);
        normalVec.m_122279_(vecB);
        int normal = (int)normalVec.m_122239_() << 24 | (int)normalVec.m_122260_() << 16 | (int)normalVec.m_122269_() << 8;
        float[][] uv = new float[][]{{u1, v1}, {u2, v1}, {u2, v2}, {u1, v2}};
        int i = 0;
        for (Vector3f vertex : vertices) {
            data[offset++] = Float.floatToIntBits(vertex.m_122239_() * 0.0625f);
            data[offset++] = Float.floatToIntBits(vertex.m_122260_() * 0.0625f);
            data[offset++] = Float.floatToIntBits(vertex.m_122269_() * 0.0625f);
            data[offset++] = -1;
            data[offset++] = Float.floatToIntBits(uv[i][0]);
            data[offset++] = Float.floatToIntBits(uv[i][1]);
            data[offset++] = 0;
            data[offset++] = normal;
            ++i;
        }
        return data;
    }
}

