/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.util.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeLoader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VoxelShape getVoxelShape(String name) {
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(VoxelShapeLoader.class.getClassLoader().getResourceAsStream("fixed_data/projectbrazier/voxel_shapes/" + name + ".json")));){
            JsonToken token = reader.peek();
            if (token == JsonToken.BEGIN_ARRAY) {
                VoxelShape voxelShape = new ShapeData(BooleanOp.f_82695_, reader).compile();
                return voxelShape;
            }
            if (token != JsonToken.BEGIN_OBJECT) return Shapes.m_83144_();
            VoxelShape voxelShape = Shapes.m_83144_();
            return voxelShape;
        }
        catch (Exception e) {
            System.out.println(name);
            e.printStackTrace();
        }
        return Shapes.m_83144_();
    }

    private static BooleanOp getFuncByName(String name) {
        switch (name) {
            case "FALSE": {
                return BooleanOp.f_82681_;
            }
            case "NOT_OR": {
                return BooleanOp.f_82682_;
            }
            case "ONLY_SECOND": {
                return BooleanOp.f_82683_;
            }
            case "NOT_FIRST": {
                return BooleanOp.f_82684_;
            }
            case "ONLY_FIRST": {
                return BooleanOp.f_82685_;
            }
            case "NOT_SECOND": {
                return BooleanOp.f_82686_;
            }
            case "NOT_SAME": {
                return BooleanOp.f_82687_;
            }
            case "NOT_AND": {
                return BooleanOp.f_82688_;
            }
            case "AND": {
                return BooleanOp.f_82689_;
            }
            case "SAME": {
                return BooleanOp.f_82690_;
            }
            case "SECOND": {
                return BooleanOp.f_82691_;
            }
            case "CAUSES": {
                return BooleanOp.f_82692_;
            }
            case "FIRST": {
                return BooleanOp.f_82693_;
            }
            case "CAUSED_BY": {
                return BooleanOp.f_82694_;
            }
            case "OR": {
                return BooleanOp.f_82695_;
            }
            case "TRUE": {
                return BooleanOp.f_82696_;
            }
        }
        return BooleanOp.f_82695_;
    }

    private static class ShapeData {
        BooleanOp function;
        List<float[]> boxes = new ArrayList<float[]>();
        List<ShapeData> subShapes = new ArrayList<ShapeData>();

        public ShapeData(BooleanOp function, JsonReader reader) throws IOException {
            this.function = function;
            reader.beginArray();
            while (reader.hasNext()) {
                JsonToken token = reader.peek();
                if (token == JsonToken.BEGIN_ARRAY) {
                    reader.beginArray();
                    float[] box = new float[6];
                    for (int i = 0; i < 6; ++i) {
                        box[i] = (float)reader.nextDouble() / 16.0f;
                    }
                    this.boxes.add(box);
                    reader.endArray();
                    continue;
                }
                if (token == JsonToken.BEGIN_OBJECT) {
                    reader.beginObject();
                    BooleanOp function2 = VoxelShapeLoader.getFuncByName(reader.nextName());
                    this.subShapes.add(new ShapeData(function2, reader));
                    reader.endObject();
                    continue;
                }
                reader.skipValue();
            }
            reader.endArray();
        }

        public VoxelShape compile() {
            return Stream.concat(this.boxes.stream().map(data -> Shapes.m_83048_((double)data[0], (double)data[1], (double)data[2], (double)data[3], (double)data[4], (double)data[5])), this.subShapes.stream().map(shape -> shape.compile())).reduce((a, b) -> Shapes.m_83113_((VoxelShape)a, (VoxelShape)b, (BooleanOp)this.function)).orElseGet(Shapes::m_83040_);
        }
    }
}

