/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.util.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.dark_roleplay.projectbrazier.util.screens.ScreenTexture;
import net.dark_roleplay.projectbrazier.util.screens.TextureList;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;

public class KeybindRenderer {
    private static Map<Integer, ScreenTexture[]> SPECIAL_KEYS = new HashMap<Integer, ScreenTexture[]>();

    public static int getKeybindWidth(KeyMapping keybind, Font fontRenderer) {
        if (SPECIAL_KEYS.containsKey(keybind.getKey().m_84873_())) {
            return 13;
        }
        return fontRenderer.m_92852_((FormattedText)keybind.m_90863_()) + 7;
    }

    public static void renderKeybind(KeyMapping keybind, PoseStack matrix, Font fontRenderer, int posX, int posY, boolean centered) {
        boolean isPressed;
        ScreenTexture up = TextureList.KEYBOARD_BUTTON;
        ScreenTexture down = TextureList.KEYBOARD_BUTTON_PRESSED;
        boolean isSpecialKey = false;
        ScreenTexture[] textures = SPECIAL_KEYS.get(keybind.getKey().m_84873_());
        if (textures != null) {
            up = textures[0];
            down = textures[1];
            isSpecialKey = true;
        }
        boolean bl = isPressed = Minecraft.m_91087_().f_91073_.m_46467_() % 30L > 15L;
        if (isSpecialKey) {
            if (isPressed) {
                up.render(matrix, posX, posY);
            } else {
                down.render(matrix, posX, posY);
            }
        } else {
            int width = fontRenderer.m_92852_((FormattedText)keybind.m_90863_()) + 7;
            (isPressed ? TextureList.KEYBOARD_BUTTON_PRESSED : TextureList.KEYBOARD_BUTTON).renderSegmented(matrix, posX - (centered ? width / 2 : 0), posY, width, 13);
            fontRenderer.m_92889_(matrix, keybind.m_90863_(), (float)(posX - (centered ? width / 2 : 0) + 4), (float)(posY + (isPressed ? 3 : 2)), -1);
        }
    }

    static {
        SPECIAL_KEYS.put(265, new ScreenTexture[]{TextureList.KEYBOARD_BUTTONS_TEXTURE.createTexture(0, 26, 13, 39), TextureList.KEYBOARD_BUTTONS_TEXTURE.createTexture(0, 39, 13, 52)});
        SPECIAL_KEYS.put(264, new ScreenTexture[]{TextureList.KEYBOARD_BUTTONS_TEXTURE.createTexture(13, 26, 26, 39), TextureList.KEYBOARD_BUTTONS_TEXTURE.createTexture(13, 39, 26, 52)});
        SPECIAL_KEYS.put(263, new ScreenTexture[]{TextureList.KEYBOARD_BUTTONS_TEXTURE.createTexture(26, 26, 39, 39), TextureList.KEYBOARD_BUTTONS_TEXTURE.createTexture(26, 39, 39, 52)});
        SPECIAL_KEYS.put(262, new ScreenTexture[]{TextureList.KEYBOARD_BUTTONS_TEXTURE.createTexture(39, 26, 52, 39), TextureList.KEYBOARD_BUTTONS_TEXTURE.createTexture(39, 39, 52, 52)});
    }
}

