/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.client.model;

import fuzs.diagonalfences.block.IEightWayBlock;
import fuzs.diagonalfences.client.model.MultipartSegmentBakedModel;
import fuzs.diagonalfences.client.model.QuadUtils;
import fuzs.diagonalfences.util.EightWayDirection;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class MultipartAppender {
    private static final Field SELECTOR_FIELD = ObfuscationReflectionHelper.findField(MultiPartBakedModel.class, (String)"f_119459_");
    private static final Random RAND = new Random();

    public static MultiPartBakedModel appendDiagonalSelectors(Block block, Map<BlockState, Direction> oneArmStates, MultiPartBakedModel model) {
        ArrayList<Pair<Predicate<BlockState>, BakedModel>> selectors = new ArrayList<Pair<Predicate<BlockState>, BakedModel>>(MultipartAppender.getMultiPartSelectors(model));
        ArrayList<Pair> newSelectors = new ArrayList<Pair>();
        for (Pair pair : selectors) {
            for (Map.Entry<BlockState, Direction> armEntry : oneArmStates.entrySet()) {
                if (((Predicate)pair.getKey()).test(block.m_49966_()) || !((Predicate)pair.getKey()).test(armEntry.getKey())) continue;
                BooleanProperty diagonalProp = MultipartAppender.getClockwiseIntercardinalProperty(armEntry.getValue());
                newSelectors.add(Pair.of(state -> (Boolean)state.m_61143_((Property)diagonalProp), (Object)MultipartAppender.rotateMultipartSegment(armEntry.getKey(), (BakedModel)pair.getValue(), armEntry.getValue())));
            }
        }
        selectors.addAll(newSelectors);
        return new MultiPartBakedModel(selectors);
    }

    private static BakedModel rotateMultipartSegment(BlockState state, BakedModel segmentModel, Direction armDir) {
        HashMap<Direction, List<BakedQuad>> quadMap = new HashMap<Direction, List<BakedQuad>>();
        MultipartAppender.rotateQuads(quadMap, state, segmentModel, null, armDir);
        for (Direction cullFace : Direction.values()) {
            MultipartAppender.rotateQuads(quadMap, state, segmentModel, cullFace, armDir);
        }
        return new MultipartSegmentBakedModel(segmentModel, quadMap);
    }

    private static void rotateQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, BakedModel segmentModel, Direction cullFace, Direction segmentDir) {
        List quads = segmentModel.getQuads(state, cullFace, RAND, (IModelData)EmptyModelData.INSTANCE);
        ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>();
        for (BakedQuad quad : quads) {
            BakedQuad copy = QuadUtils.duplicateQuad(quad);
            QuadUtils.rotateQuad(copy, segmentDir);
            newQuads.add(copy);
        }
        quadMap.put(cullFace, newQuads);
    }

    private static BooleanProperty getClockwiseIntercardinalProperty(Direction cardinal) {
        EightWayDirection dir = EightWayDirection.byIndex(cardinal.m_122416_(), true);
        return IEightWayBlock.DIRECTION_TO_PROPERTY_MAP.get((Object)dir);
    }

    private static List<Pair<Predicate<BlockState>, BakedModel>> getMultiPartSelectors(MultiPartBakedModel model) {
        try {
            return (List)SELECTOR_FIELD.get(model);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

