/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.util.math.shapes;

import com.google.common.collect.Lists;
import fuzs.diagonalfences.util.math.shapes.ExtensibleVoxelShape;
import fuzs.diagonalfences.util.math.shapes.NoneVoxelShape;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelCollection
extends ExtensibleVoxelShape {
    private VoxelShape collisionShape;
    private VoxelShape outlineShape;
    private final List<NoneVoxelShape> noneVoxels = Lists.newArrayList();

    public VoxelCollection() {
        this(Shapes.m_83040_());
    }

    public VoxelCollection(VoxelShape baseShape) {
        super(baseShape);
        this.collisionShape = baseShape;
        this.outlineShape = baseShape;
    }

    @Override
    protected DoubleList m_7700_(Direction.Axis axis) {
        return this.callGetValues(this.collisionShape, axis);
    }

    private void setCollisionShape(VoxelShape voxelShape) {
        this.collisionShape = voxelShape;
        this.setVoxelPart((VoxelShape)this, this.getVoxelPart(this.collisionShape));
    }

    public void addVoxelShape(VoxelShape voxelShape) {
        if (voxelShape instanceof NoneVoxelShape) {
            this.addNoneVoxelShape((NoneVoxelShape)voxelShape);
        } else {
            this.setCollisionShape(Shapes.m_83110_((VoxelShape)this.collisionShape, (VoxelShape)voxelShape));
            this.outlineShape = Shapes.m_83110_((VoxelShape)this.outlineShape, (VoxelShape)voxelShape);
        }
    }

    private void addNoneVoxelShape(NoneVoxelShape voxelShape) {
        this.noneVoxels.add(voxelShape);
        this.setCollisionShape(Shapes.m_83110_((VoxelShape)this.collisionShape, (VoxelShape)voxelShape));
    }

    public void m_83224_(Shapes.DoubleLineConsumer boxConsumer) {
        this.outlineShape.m_83224_(boxConsumer);
        this.noneVoxels.forEach(voxelShape -> voxelShape.m_83224_(boxConsumer));
    }
}

