/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.GamePath;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitEnabled;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitProperties;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeBlock
extends Block
implements IForgeUnit<Block> {
    public static final AABB FULL_BLOCK_AABB = Shapes.m_83144_().m_83215_();
    private final UnitEnabled unitEnabled;
    private final UnitConfig config;
    private final ResourceLocation textureLocation;

    public ForgeBlock(AbstractForgeMod mod, UnitConfig config, Properties<?> props) {
        this(mod, config, props.name, ((Properties)props.setBlockProps()).blockProps);
    }

    public ForgeBlock(AbstractForgeMod mod, UnitConfig config, String name, BlockBehaviour.Properties props) {
        super(props);
        this.setRegistryName(new ResourceLocation(mod.getId(), name));
        this.config = config;
        this.unitEnabled = new UnitEnabled(config, this.getUnitCategory(), true);
        this.textureLocation = GamePath.blockTexture((ResourceLocation)this.getRegistryName(), (String[])new String[0]).location;
    }

    public static boolean isUnderRain(Level world, BlockPos pos) {
        return world.m_46758_(pos.m_7494_());
    }

    public static boolean isUnderOpenSky(Level world, BlockPos pos) {
        return world.m_45527_(pos.m_7494_());
    }

    @Nullable
    public static Block getBlockOrNull(Item item) {
        return item instanceof BlockItem ? ((BlockItem)item).m_40614_() : null;
    }

    public static <T extends Enum<T>> EnumProperty<T> createEnumProperty(Class<T> clazz) {
        return EnumProperty.m_61587_((String)IForgeUnit.getClassRegName(clazz), clazz);
    }

    public static UnitConfig createDefaultConfig(AbstractForgeMod mod, String blockName) {
        Path baseDir = mod.getConfigsDir().resolve("blocks");
        String configName = UnitId.dictToRegName(blockName);
        return UnitConfig.in(baseDir, configName);
    }

    public static ResourceLocation getRegistryName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
    }

    public static ResourceLocation getRegistryName(Fluid fluid) {
        return ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)fluid);
    }

    public ResourceLocation getTextureLocationFor(BlockState state) {
        return this.textureLocation;
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.isEnabled()) {
            super.m_49811_(group, items);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.unitEnabled.isEnabled();
    }

    public static boolean isRegistered(Block block) {
        return ForgeRegistries.BLOCKS.containsValue((IForgeRegistryEntry)block);
    }

    public static float getHardnessFrom(UnitConfig config, String category, float defaultValue) {
        return UnitConfig.getFloat(config, category, "hardness", defaultValue, new FloatBounds(Float.valueOf(-1.0f), Float.valueOf(Float.MAX_VALUE)), "Defines how many hits it takes to break the block.\n -1 makes the block indestructible.");
    }

    public static float getResistanceFrom(UnitConfig config, String category, float defaultValue) {
        return UnitConfig.getFloat(config, category, "resistance", defaultValue, new FloatBounds(Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)), "Defines the block resistance to explosions.");
    }

    @Override
    public UnitConfig getConfig() {
        return this.config;
    }

    public static class Properties<T extends Properties<T>>
    extends UnitProperties<T> {
        public final String name;
        public final Material material;
        public final BlockBehaviour.Properties blockProps;

        public static Properties<?> with(String name, Material material) {
            return new Properties<Properties>(Properties.class, name, material);
        }

        protected Properties(Class<T> selfClass, String name, Material material) {
            super(selfClass);
            this.name = name;
            this.material = material;
            this.blockProps = BlockBehaviour.Properties.m_60939_((Material)material);
        }

        public T setBlockProps() {
            return (T)((Properties)this.self);
        }

        public T randomTicks() {
            this.blockProps.m_60977_();
            return (T)((Properties)this.self);
        }

        public T noOcclusion() {
            this.blockProps.m_60955_();
            return (T)((Properties)this.self);
        }
    }
}

