/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ClientRegistry;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public final class GameKeys {
    protected static final String KEY = "key";
    protected static final String CATEGORIES = "categories";
    protected static final String DELIMITER = ".";

    public static boolean affectPlayer() {
        return Minecraft.m_91087_().f_91080_ == null;
    }

    public static boolean affectMenus() {
        return !GameKeys.affectPlayer();
    }

    public static Options getGameSettings() {
        return Minecraft.m_91087_().f_91066_;
    }

    public static Window getMainWindow() {
        return Minecraft.m_91087_().m_91268_();
    }

    public static boolean isShiftDown() {
        long handle = GameKeys.getMainWindow().m_85439_();
        return InputConstants.m_84830_((long)handle, (int)340) || InputConstants.m_84830_((long)handle, (int)344);
    }

    public static boolean isControlDown() {
        long handle = GameKeys.getMainWindow().m_85439_();
        if (Minecraft.f_91002_) {
            return InputConstants.m_84830_((long)handle, (int)343) || InputConstants.m_84830_((long)handle, (int)347);
        }
        return InputConstants.m_84830_((long)handle, (int)341) || InputConstants.m_84830_((long)handle, (int)345);
    }

    public static boolean isDown(int GLFW_KeyCode) {
        if (GLFW_KeyCode == -1) {
            return false;
        }
        if (GLFW_KeyCode <= 7) {
            return GLFW.glfwGetMouseButton((long)GameKeys.getMainWindow().m_85439_(), (int)GLFW_KeyCode) == 1;
        }
        if (GLFW_KeyCode >= 32 && GLFW_KeyCode <= 348) {
            return GLFW.glfwGetKey((long)GameKeys.getMainWindow().m_85439_(), (int)GLFW_KeyCode) == 1;
        }
        return false;
    }

    public static boolean isAltDown() {
        long handle = GameKeys.getMainWindow().m_85439_();
        return InputConstants.m_84830_((long)handle, (int)342) || InputConstants.m_84830_((long)handle, (int)346);
    }

    public static KeyMapping createBindingFor(ResourceLocation actionName, int keyCode, KeyCategories keyCategory) {
        KeyMapping keyBinding = new KeyMapping(Args.joinDelim(DELIMITER, "keybind", actionName.m_135827_(), actionName.m_135815_()), keyCode, keyCategory.getName());
        ClientRegistry.registerKeyBinding((KeyMapping)keyBinding);
        return keyBinding;
    }

    public static enum KeyCategories implements IForgeEnum
    {
        NONE,
        MOVEMENT,
        GAMEPLAY,
        INVENTORY,
        CREATIVE,
        MULTIPLAYER,
        UI,
        MISC;


        @Override
        public String getName() {
            return Args.joinDelim(GameKeys.DELIMITER, GameKeys.KEY, GameKeys.CATEGORIES, IForgeEnum.super.getName());
        }
    }
}

