/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.walkingcanes.event;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class ToothAdditionModifier
extends LootModifier {
    private final Item addedItem;

    protected ToothAdditionModifier(LootItemCondition[] conditionsIn, Item addeditemIn) {
        super(conditionsIn);
        this.addedItem = addeditemIn;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if ((double)context.m_78933_().nextFloat() > 0.75) {
            generatedLoot.add(new ItemStack((ItemLike)this.addedItem, 1));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ToothAdditionModifier> {
        public ToothAdditionModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] ailootcondition) {
            Item addedItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"item")));
            return new ToothAdditionModifier(ailootcondition, addedItem);
        }

        public JsonObject write(ToothAdditionModifier instance) {
            return new JsonObject();
        }
    }
}

