/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.config.ExoticBirdsCommonConfig;
import net.pavocado.exoticbirds.entity.AbstractFlyingBirdEntity;
import net.pavocado.exoticbirds.entity.ai.BirdAvoidEntityGoal;
import net.pavocado.exoticbirds.entity.ai.BirdBreedGoal;
import net.pavocado.exoticbirds.entity.ai.BirdTemptGoal;
import net.pavocado.exoticbirds.entity.ai.FlyTowardsTreeGoal;
import net.pavocado.exoticbirds.entity.ai.LayEggInNestGoal;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSoundEvents;

public class WoodpeckerEntity
extends AbstractFlyingBirdEntity {
    private static final EntityDataAccessor<Boolean> IS_HANGING = SynchedEntityData.m_135353_(WoodpeckerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final TargetingConditions PLAYER_TARGETING = TargetingConditions.m_148353_().m_26883_(3.0);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_});
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/woodpecker/woodpecker_greater.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/woodpecker/woodpecker_green.png"));
        hashMap.put(2, new ResourceLocation("exoticbirds:textures/entity/woodpecker/woodpecker_pileated.png"));
    });
    @Nullable
    private BlockPos treePos;
    private boolean isPecking;
    private float timeIsPecking;
    private float prevTimeIsPecking;
    private int nextSearchDelay;

    public WoodpeckerEntity(EntityType<? extends WoodpeckerEntity> type, Level level) {
        super(type, level, new ItemStack((ItemLike)ExoticBirdsItems.WOODPECKER_EGG.get()), BIRD_TEXTURES.size(), false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.setIsHanging(true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new BirdBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new BirdTemptGoal(this, 0.8, FOOD_ITEMS, true));
        this.f_21345_.m_25352_(2, new BirdAvoidEntityGoal<Player>(this, Player.class, 16.0f, 0.8f, 1.33));
        this.f_21345_.m_25352_(3, (Goal)new HangOnTreeGoal());
        this.f_21345_.m_25352_(4, (Goal)new FlyTowardsTreeGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LayEggInNestGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_HANGING, (Object)false);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions size) {
        return this.m_6162_() ? size.f_20378_ * 0.85f : size.f_20378_ * 0.92f;
    }

    protected void scareBird() {
        this.nextSearchDelay = 50 + this.f_19796_.nextInt(200);
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        if (this.getIsHanging()) {
            return super.m_6972_(poseIn).m_20390_(0.7f, 1.7f);
        }
        return super.m_6972_(poseIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 2.0);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        if (!this.getIsHanging()) {
            return (SoundEvent)ExoticBirdsSoundEvents.ENTITY_WOODPECKER_AMBIENT.get();
        }
        return super.m_7515_();
    }

    public WoodpeckerEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        WoodpeckerEntity woodpecker = (WoodpeckerEntity)((EntityType)ExoticBirdsEntities.WOODPECKER.get()).m_20615_((Level)serverLevel);
        woodpecker.setVariant(this.getChildVariant());
        return woodpecker;
    }

    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    public boolean getIsHanging() {
        return (Boolean)this.f_19804_.m_135370_(IS_HANGING);
    }

    public void setIsHanging(boolean isHanging) {
        this.f_19804_.m_135381_(IS_HANGING, (Object)isHanging);
        if (!isHanging) {
            this.isPecking = false;
            this.prevTimeIsPecking = 0.0f;
            this.timeIsPecking = 0.0f;
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.treePos = this.findTreeLocation();
        if (!this.f_19853_.m_5776_() && this.getIsHanging() && !this.m_20067_() && !this.isPecking && this.f_19796_.nextInt(500) == 0) {
            this.isPecking = true;
            this.timeIsPecking = 0.0f;
            this.prevTimeIsPecking = 0.0f;
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ExoticBirdsSoundEvents.ENTITY_WOODPECKER_PECK.get(), SoundSource.AMBIENT, this.m_6121_(), 0.8f + 0.4f * this.f_19796_.nextFloat());
            this.f_19853_.m_7605_((Entity)this, (byte)8);
        }
        if (this.f_19853_.m_5776_() && this.getIsHanging()) {
            this.f_20883_ = this.f_20885_ = (float)this.getRotationForTree();
        }
    }

    public int getRotationForTree() {
        BlockPos currPos = this.m_142538_();
        if (this.treePos != null) {
            if (currPos.m_142127_().equals((Object)this.treePos)) {
                return 180;
            }
            if (currPos.m_142126_().equals((Object)this.treePos)) {
                return 270;
            }
            if (currPos.m_142128_().equals((Object)this.treePos)) {
                return 0;
            }
            if (currPos.m_142125_().equals((Object)this.treePos)) {
                return 90;
            }
        }
        return 0;
    }

    public void m_6667_(DamageSource cause) {
        this.isPecking = false;
        this.prevTimeIsPecking = 0.0f;
        this.timeIsPecking = 0.0f;
        super.m_6667_(cause);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 8) {
            this.isPecking = true;
            this.timeIsPecking = 0.0f;
            this.prevTimeIsPecking = 0.0f;
        } else {
            super.m_7822_(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getPeckAngle(float partialTick, float offset) {
        float f = (Mth.m_14179_((float)partialTick, (float)this.prevTimeIsPecking, (float)this.timeIsPecking) + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.m_14031_((float)(f * (float)Math.PI)) * Mth.m_14031_((float)(f * (float)Math.PI * 15.0f)) * 0.15f * (float)Math.PI - 1.802233f;
    }

    @Override
    public boolean m_6090_() {
        return true;
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && this.getIsHanging()) {
            this.setIsHanging(false);
            this.scareBird();
        }
        return super.m_6469_(damageSource, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getIsHanging()) {
            this.m_20256_(Vec3.f_82478_);
            this.m_20343_((double)Mth.m_14107_((double)this.m_20185_()) + 0.5, Math.round(this.m_20186_()), (double)Mth.m_14107_((double)this.m_20189_()) + 0.5);
        }
        if (this.isPecking && !this.m_20067_()) {
            this.prevTimeIsPecking = this.timeIsPecking;
            this.timeIsPecking += 0.05f;
            if (this.prevTimeIsPecking >= 2.0f) {
                this.isPecking = false;
                this.prevTimeIsPecking = 0.0f;
                this.timeIsPecking = 0.0f;
            }
        }
        if (this.f_19853_.f_46443_) {
            this.m_6210_();
        }
    }

    @Override
    public void m_8024_() {
        super.m_8024_();
        BlockPos blockpos = this.m_142538_();
        if (this.getIsHanging()) {
            boolean flag = this.m_20067_();
            if (this.treePos != null && this.f_19853_.m_8055_(this.treePos).m_60796_((BlockGetter)this.f_19853_, blockpos)) {
                if (this.f_19853_.m_45946_(PLAYER_TARGETING, (LivingEntity)this) != null) {
                    this.setIsHanging(false);
                    this.scareBird();
                    if (!flag) {
                        this.f_19853_.m_5898_(null, 1025, blockpos, 0);
                    }
                }
            } else {
                this.setIsHanging(false);
                if (!flag) {
                    this.f_19853_.m_5898_(null, 1025, blockpos, 0);
                }
            }
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(IS_HANGING, (Object)tag.m_128471_("WoodpeckerFlags"));
        this.treePos = null;
        if (tag.m_128441_("TreePos")) {
            this.treePos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("TreePos"));
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("WoodpeckerFlags", ((Boolean)this.f_19804_.m_135370_(IS_HANGING)).booleanValue());
        if (this.treePos != null) {
            tag.m_128365_("TreePos", (Tag)NbtUtils.m_129224_((BlockPos)this.treePos));
        }
    }

    @Nullable
    public BlockPos findTreeLocation() {
        BlockPos[] pos;
        BlockPos blockpos = this.m_142538_();
        for (BlockPos currentPos : pos = new BlockPos[]{blockpos.m_142127_(), blockpos.m_142126_(), blockpos.m_142128_(), blockpos.m_142125_()}) {
            BlockState blockState = this.f_19853_.m_8055_(currentPos);
            if (!blockState.m_60796_((BlockGetter)this.f_19853_, currentPos) || !blockState.m_204336_(BlockTags.f_13106_)) continue;
            return currentPos;
        }
        return null;
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return (List)ExoticBirdsCommonConfig.blacklistedDimensionsWoodpecker.get();
    }

    @Override
    public List<ItemStack> getTemptingItems() {
        return Arrays.asList(FOOD_ITEMS.m_43908_());
    }

    public class HangOnTreeGoal
    extends Goal {
        public HangOnTreeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8045_() {
            return WoodpeckerEntity.this.getIsHanging();
        }

        public boolean m_8036_() {
            List list;
            if (WoodpeckerEntity.this.nextSearchDelay > 0) {
                --WoodpeckerEntity.this.nextSearchDelay;
                return false;
            }
            if (WoodpeckerEntity.this.getIsHanging()) {
                return true;
            }
            Level level = WoodpeckerEntity.this.f_19853_;
            if (WoodpeckerEntity.this.treePos != null && level.m_8055_(WoodpeckerEntity.this.treePos).m_60796_((BlockGetter)level, WoodpeckerEntity.this.treePos) && level.m_8055_(WoodpeckerEntity.this.m_142538_().m_7495_()).m_60795_() && WoodpeckerEntity.this.m_21187_().nextInt(20) == 0 && (list = level.m_6249_((Entity)WoodpeckerEntity.this, new AABB(WoodpeckerEntity.this.m_20185_() - 0.5, WoodpeckerEntity.this.m_20186_() - 0.5, WoodpeckerEntity.this.m_20189_() - 0.5, WoodpeckerEntity.this.m_20185_() + 0.5, WoodpeckerEntity.this.m_20186_() + 0.5, WoodpeckerEntity.this.m_20189_() + 0.5), EntitySelector.f_20403_)).isEmpty()) {
                WoodpeckerEntity.this.setIsHanging(true);
                return true;
            }
            return false;
        }

        public void m_8056_() {
            WoodpeckerEntity.this.m_21573_().m_26573_();
        }

        public void m_8041_() {
            WoodpeckerEntity.this.treePos = null;
        }
    }
}

