/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity.phoenix;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.pavocado.exoticbirds.entity.AbstractPhoenixEntity;
import net.pavocado.exoticbirds.init.ExoticBirdsBlocks;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;

public class EnderPhoenixEntity
extends AbstractPhoenixEntity {
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.m_137469_((Object)Maps.newHashMap(), hashMap -> hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/phoenix/ender_phoenix.png")));

    public EnderPhoenixEntity(EntityType<? extends EnderPhoenixEntity> type, Level level) {
        super(type, level, new ItemStack((ItemLike)ExoticBirdsBlocks.ENDER_PHOENIX_EGG.get()));
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    public EnderPhoenixEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        EnderPhoenixEntity phoenix = (EnderPhoenixEntity)((EntityType)ExoticBirdsEntities.ENDER_PHOENIX.get()).m_20615_((Level)serverLevel);
        return phoenix;
    }

    @Override
    public void spawnAmbientParticles() {
        for (int i = 0; i < 2; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.nextDouble() * (double)this.m_20206_() / 3.0, this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.nextDouble() * (double)this.m_20206_() / 3.0, this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.m_6126_() && this.m_20072_()) {
            this.m_6469_(DamageSource.f_19312_, 1.0f);
            this.teleportRandomly();
        }
    }

    protected boolean teleportRandomly() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * 32.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.nextInt(32) - 16);
            double d2 = this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * 32.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleport(double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76334_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }
}

