/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.network;

import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketLogPhoenixEgg {
    private final BlockPos eggPos;
    private final int hatchRate;

    public PacketLogPhoenixEgg(BlockPos eggPos, int hatchRate) {
        this.eggPos = eggPos;
        this.hatchRate = hatchRate;
    }

    public static void encode(PacketLogPhoenixEgg message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.eggPos);
        buffer.writeInt(message.hatchRate);
    }

    public static PacketLogPhoenixEgg decode(FriendlyByteBuf buffer) {
        return new PacketLogPhoenixEgg(buffer.m_130135_(), buffer.readInt());
    }

    public static void handle(PacketLogPhoenixEgg packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketLogPhoenixEgg.handleOnClient(packet)));
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(PacketLogPhoenixEgg packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            float hatchPercentage = 100.0f * ((float)(48000 - packet.hatchRate) / 48000.0f);
            player.m_6352_((Component)new TranslatableComponent("egg.exoticbirds.status", new Object[]{String.format("%.2f", Float.valueOf(hatchPercentage))}), Util.f_137441_);
        }
    }
}

