/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.nosort;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;

public class NoSortSettingsContainer
extends SettingsContainerBase<NoSortSettingsCategory> {
    private static final String ACTION_TAG = "action";
    private static final String SELECT_ALL_ACTION = "selectAll";
    private static final String UNSELECT_ALL_ACTION = "unselectAll";
    private static final String UNSELECT_SLOT_TAG = "unselectSlot";
    private static final String SELECT_SLOT_TAG = "selectSlot";
    private static final String COLOR_TAG = "color";

    public NoSortSettingsContainer(SettingsContainer<?> settingsContainer, String categoryName, NoSortSettingsCategory category) {
        super(settingsContainer, categoryName, category);
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(ACTION_TAG)) {
            switch (data.m_128461_(ACTION_TAG)) {
                case "selectAll": {
                    this.selectAllSlots();
                    break;
                }
                case "unselectAll": {
                    this.unselectAllSlots();
                    break;
                }
            }
        } else if (data.m_128441_(SELECT_SLOT_TAG)) {
            this.selectSlot(data.m_128451_(SELECT_SLOT_TAG));
        } else if (data.m_128441_(UNSELECT_SLOT_TAG)) {
            this.unselectSlot(data.m_128451_(UNSELECT_SLOT_TAG));
        } else if (data.m_128441_(COLOR_TAG)) {
            this.setColor(DyeColor.m_41053_((int)data.m_128451_(COLOR_TAG)));
        }
    }

    public void unselectSlot(int slotNumber) {
        if (!this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).unselectSlot(slotNumber);
        } else {
            this.sendIntToServer(UNSELECT_SLOT_TAG, slotNumber);
        }
    }

    public void selectSlot(int slotNumber) {
        if (this.isSlotSelected(slotNumber)) {
            return;
        }
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).selectSlot(slotNumber);
        } else {
            this.sendIntToServer(SELECT_SLOT_TAG, slotNumber);
        }
    }

    public void unselectAllSlots() {
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).unselectAllSlots();
        } else {
            this.sendStringToServer(ACTION_TAG, UNSELECT_ALL_ACTION);
        }
    }

    public void selectAllSlots() {
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).selectSlots(0, this.getSettingsContainer().getNumberOfSlots());
        } else {
            this.sendStringToServer(ACTION_TAG, SELECT_ALL_ACTION);
        }
    }

    public void setColor(DyeColor color) {
        if (this.isServer()) {
            ((NoSortSettingsCategory)this.getCategory()).setColor(color);
        } else {
            this.sendIntToServer(COLOR_TAG, color.m_41060_());
        }
    }

    public boolean isSlotSelected(int slotNumber) {
        return ((NoSortSettingsCategory)this.getCategory()).isSlotSelected(slotNumber);
    }

    public DyeColor getColor() {
        return ((NoSortSettingsCategory)this.getCategory()).getColor();
    }
}

