/*
 * Decompiled with CFR 0.152.
 */
package fuzs.airhop.client.handler;

import fuzs.airhop.AirHop;
import fuzs.airhop.capability.AirHopsCapability;
import fuzs.airhop.config.ServerConfig;
import fuzs.airhop.handler.PlayerFallHandler;
import fuzs.airhop.mixin.accessor.LivingEntityAccessor;
import fuzs.airhop.network.client.message.C2SAirHopMessage;
import fuzs.airhop.registry.ModRegistry;
import fuzs.puzzleslib.network.message.Message;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AirHopHandler {
    @SubscribeEvent
    public void onPlayerTick$end(TickEvent.PlayerTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = evt.player;
        if (((LivingEntityAccessor)player).getJumping() && ((LivingEntityAccessor)player).getNoJumpDelay() == 0 && this.attemptJump(player)) {
            ((LivingEntityAccessor)player).setNoJumpDelay(10);
            AirHop.NETWORK.sendToServer((Message)new C2SAirHopMessage());
        }
    }

    private boolean attemptJump(Player player) {
        AirHopsCapability capability;
        LazyOptional optional;
        if (this.canJump(player) && this.isSaturated(player) && (optional = player.getCapability(ModRegistry.AIR_HOPS_CAPABILITY)).isPresent() && (capability = (AirHopsCapability)optional.orElseThrow(IllegalStateException::new)).getAirHops() < EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModRegistry.AIR_HOP_ENCHANTMENT.get()), (LivingEntity)player)) {
            player.m_6135_();
            player.m_183634_();
            capability.addAirHop();
            return true;
        }
        return false;
    }

    private boolean canJump(Player player) {
        if (!(player.m_20096_() || ((ServerConfig)AirHop.CONFIG.server()).fallingOnly && !(PlayerFallHandler.getJumpHeight(player) / 2.0f < player.f_19789_) || player.m_20159_() || player.m_150110_().f_35935_ || player.m_6147_())) {
            return !player.m_20069_() && !player.m_20077_();
        }
        return false;
    }

    private boolean isSaturated(Player player) {
        return player.m_150110_().f_35936_ || !((ServerConfig)AirHop.CONFIG.server()).disableOnHungry || player.m_36324_().m_38702_() > 6;
    }
}

