/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.blocks.base.ISeat;
import com.mrh0.buildersaddition.entity.SeatEntity;
import com.mrh0.buildersaddition.state.BenchState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Bench
extends BaseDerivativeBlock
implements ISeat {
    public static final EnumProperty<BenchState> STATE = EnumProperty.m_61587_((String)"state", BenchState.class);
    protected static final VoxelShape SHAPE_X = Block.m_49796_((double)0.0, (double)7.0, (double)2.0, (double)16.0, (double)9.0, (double)14.0);
    protected static final VoxelShape SHAPE_Z = Block.m_49796_((double)2.0, (double)7.0, (double)0.0, (double)14.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)7.0, (double)3.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)7.0, (double)15.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)3.0, (double)7.0, (double)13.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)13.0, (double)0.0, (double)3.0, (double)15.0, (double)7.0, (double)13.0);

    public Bench(String name) {
        super("bench_" + name, Blocks.f_50705_);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)BenchState.Both_X)));
    }

    public Bench(String name, Block source) {
        super("bench_" + name, source);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)BenchState.Both_X)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STATE});
    }

    public VoxelShape getShape(BlockState state) {
        VoxelShape shape = SHAPE_X;
        BenchState bs = (BenchState)((Object)state.m_61143_(STATE));
        if (bs.getAxis() == Direction.Axis.Z) {
            shape = SHAPE_Z;
        }
        if (bs.hasLegNorth()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
        }
        if (bs.hasLegWest()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
        }
        if (bs.hasLegSouth()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
        }
        if (bs.hasLegEast()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
        }
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    public boolean connects(Direction.Axis current, BlockGetter worldIn, BlockPos pos, Direction dir) {
        BlockState state = worldIn.m_8055_(pos.m_142300_(dir));
        if (state.m_60734_() instanceof Bench) {
            return ((BenchState)((Object)state.m_61143_(STATE))).getAxis() == current;
        }
        return false;
    }

    public BlockState getState(Direction.Axis current, BlockGetter worldIn, BlockPos pos) {
        if (current == Direction.Axis.Z) {
            boolean n = this.connects(current, worldIn, pos, Direction.NORTH);
            boolean s = this.connects(current, worldIn, pos, Direction.SOUTH);
            if (n && !s) {
                return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)BenchState.North));
            }
            if (!n && s) {
                return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)BenchState.South));
            }
            if (n && s) {
                return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)BenchState.None_Z));
            }
            return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)BenchState.Both_Z));
        }
        boolean w = this.connects(current, worldIn, pos, Direction.WEST);
        boolean e = this.connects(current, worldIn, pos, Direction.EAST);
        if (e && !w) {
            return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)BenchState.East));
        }
        if (!e && w) {
            return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)BenchState.West));
        }
        if (e && w) {
            return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)BenchState.None_X));
        }
        return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)BenchState.Both_X));
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        if (c.m_7078_()) {
            return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)(c.m_8125_().m_122427_().m_122434_() == Direction.Axis.X ? BenchState.Both_X : BenchState.Both_Z)));
        }
        return this.getState(c.m_8125_().m_122427_().m_122434_(), (BlockGetter)c.m_43725_(), c.m_8083_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction p_60542_, BlockState p_60543_, LevelAccessor worldIn, BlockPos pos, BlockPos p_60546_) {
        return this.getState(((BenchState)((Object)stateIn.m_61143_(STATE))).getAxis(), (BlockGetter)worldIn, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand p_60507_, BlockHitResult p_60508_) {
        return SeatEntity.createSeat(worldIn, pos, (LivingEntity)player, SoundEvents.f_12634_);
    }
}

