/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.blocks.base.ISeat;
import com.mrh0.buildersaddition.entity.SeatEntity;
import com.mrh0.buildersaddition.state.SofaState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Sofa
extends BaseDerivativeBlock
implements ISeat {
    public static final EnumProperty<SofaState> STATE = EnumProperty.m_61587_((String)"state", SofaState.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape SHAPE_BASE = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SHAPE_BACK_NORTH = Block.m_49796_((double)0.0, (double)9.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_BACK_EAST = Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_BACK_SOUTH = Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    protected static final VoxelShape SHAPE_BACK_WEST = Block.m_49796_((double)12.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_ARM_NORTH = Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0);
    protected static final VoxelShape SHAPE_ARM_EAST = Block.m_49796_((double)14.0, (double)9.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_ARM_SOUTH = Block.m_49796_((double)0.0, (double)9.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_ARM_WEST = Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0);

    public Sofa(String name) {
        super("sofa_" + name, Blocks.f_50041_);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)SofaState.Both))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STATE, FACING});
    }

    private VoxelShape getArm(Direction dir) {
        switch (dir) {
            case NORTH: {
                return SHAPE_ARM_NORTH;
            }
            case EAST: {
                return SHAPE_ARM_EAST;
            }
            case SOUTH: {
                return SHAPE_ARM_SOUTH;
            }
            case WEST: {
                return SHAPE_ARM_WEST;
            }
        }
        return Shapes.m_83040_();
    }

    public VoxelShape getShape(BlockState state) {
        VoxelShape shape = Shapes.m_83040_();
        SofaState s = (SofaState)((Object)state.m_61143_(STATE));
        Direction d = (Direction)state.m_61143_((Property)FACING);
        if (s == SofaState.Left) {
            shape = this.getArm(d.m_122428_());
        }
        if (s == SofaState.Right) {
            shape = this.getArm(d.m_122427_());
        }
        if (s == SofaState.Both) {
            shape = Shapes.m_83110_((VoxelShape)this.getArm(d.m_122427_()), (VoxelShape)this.getArm(d.m_122428_()));
        }
        switch (d) {
            case EAST: {
                return Shapes.m_83124_((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_BACK_EAST, shape});
            }
            case NORTH: {
                return Shapes.m_83124_((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_BACK_NORTH, shape});
            }
            case SOUTH: {
                return Shapes.m_83124_((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_BACK_SOUTH, shape});
            }
            case WEST: {
                return Shapes.m_83124_((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_BACK_WEST, shape});
            }
        }
        return SHAPE_BASE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    public boolean connects(Direction current, LevelAccessor worldIn, BlockPos pos, Direction dir, boolean disCheck) {
        BlockState adj = worldIn.m_8055_(pos.m_142300_(dir));
        if (adj.m_60734_() instanceof Sofa) {
            SofaState s = (SofaState)((Object)adj.m_61143_(STATE));
            Direction sd = (Direction)adj.m_61143_((Property)FACING);
            if ((s == SofaState.Both || current == sd && dir == current.m_122427_() && s == SofaState.Left || current == sd && dir == current.m_122428_() && s == SofaState.Right) && !disCheck) {
                return false;
            }
            return current == adj.m_61143_((Property)FACING);
        }
        return false;
    }

    public BlockState getState(Direction dir, LevelAccessor worldIn, BlockPos pos, boolean disCheck) {
        boolean l = this.connects(dir, worldIn, pos, dir.m_122427_(), disCheck);
        boolean r = this.connects(dir, worldIn, pos, dir.m_122428_(), disCheck);
        if (l && !r) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)SofaState.Left))).m_61124_((Property)FACING, (Comparable)dir);
        }
        if (!l && r) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)SofaState.Right))).m_61124_((Property)FACING, (Comparable)dir);
        }
        if (l && r) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)SofaState.None))).m_61124_((Property)FACING, (Comparable)dir);
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)SofaState.Both))).m_61124_((Property)FACING, (Comparable)dir);
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        if (c.m_7078_()) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)c.m_8125_().m_122424_())).m_61124_(STATE, (Comparable)((Object)SofaState.Both));
        }
        return this.getState(c.m_8125_().m_122424_(), (LevelAccessor)c.m_43725_(), c.m_8083_(), true);
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState otherState, LevelAccessor world, BlockPos pos, BlockPos otherPos) {
        return this.getState((Direction)state.m_61143_((Property)FACING), world, pos, false);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return SeatEntity.createSeat(world, pos, (LivingEntity)player, SoundEvents.f_12641_);
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity ent, float dis) {
        super.m_142072_(world, state, pos, ent, dis * 0.5f);
    }

    public void m_5548_(BlockGetter world, Entity entityIn) {
        if (entityIn.m_20162_()) {
            super.m_5548_(world, entityIn);
        } else {
            this.bounceUp(entityIn);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vector3d = entity.m_20184_();
        if (vector3d.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vector3d.f_82479_, -vector3d.f_82480_ * (double)0.66f * d0, vector3d.f_82481_);
        }
    }
}

