/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemDrawers
extends BlockItem {
    public ItemDrawers(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        TranslatableComponent textCapacity = new TranslatableComponent("tooltip.storagedrawers.drawers.capacity", new Object[]{this.getCapacityForBlock(stack)});
        tooltip.add((Component)new TextComponent("").m_7220_((Component)textCapacity).m_130940_(ChatFormatting.GRAY));
        if (stack.m_41782_() && stack.m_41783_().m_128441_("tile")) {
            TranslatableComponent textSealed = new TranslatableComponent("tooltip.storagedrawers.drawers.sealed");
            tooltip.add((Component)new TextComponent("").m_7220_((Component)textSealed).m_130940_(ChatFormatting.YELLOW));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_41466_() {
        return new TranslatableComponent(this.m_5524_() + ".desc");
    }

    private int getCapacityForBlock(@Nonnull ItemStack itemStack) {
        Block block = Block.m_49814_((Item)itemStack.m_41720_());
        if (block instanceof BlockDrawers) {
            BlockDrawers drawers = (BlockDrawers)block;
            return drawers.getStorageUnits() * CommonConfig.GENERAL.getBaseStackStorage();
        }
        return 0;
    }
}

