/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sereneseasons.config.FertilityConfig;
import sereneseasons.init.ModFertility;
import sereneseasons.init.ModTags;

@Mod.EventBusSubscriber
public class SeasonalCropGrowthHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onItemTooltipAdded(ItemTooltipEvent event) {
        ModFertility.setupTooltips(event);
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        ModFertility.populate();
    }

    @SubscribeEvent
    public void onCropGrowth(BlockEvent.CropGrowEvent event) {
        BlockState plant = event.getState();
        Block plantBlock = plant.m_60734_();
        Level world = (Level)event.getWorld();
        boolean isFertile = ModFertility.isCropFertile(plantBlock.getRegistryName().toString(), world, event.getPos());
        if (((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && !isFertile && !this.isGlassAboveBlock(world, event.getPos())) {
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 0 && world.m_5822_().nextInt(6) != 0) {
                event.setResult(Event.Result.DENY);
            }
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 1) {
                event.setResult(Event.Result.DENY);
            }
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 2) {
                if (!plant.m_204336_(ModTags.Blocks.UNBREAKABLE_INFERTILE_CROPS)) {
                    event.setResult(Event.Result.DENY);
                    event.getWorld().m_46961_(event.getPos(), false);
                } else {
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent
    public void onApplyBonemeal(BonemealEvent event) {
        BlockState plant = event.getBlock();
        Block plantBlock = plant.m_60734_();
        boolean isFertile = ModFertility.isCropFertile(plantBlock.getRegistryName().toString(), event.getWorld(), event.getPos());
        if (((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && !isFertile && !this.isGlassAboveBlock(event.getWorld(), event.getPos())) {
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 0 && event.getWorld().m_5822_().nextInt(6) != 0) {
                event.setResult(Event.Result.DEFAULT);
            }
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 1) {
                event.setCanceled(true);
            }
            if ((Integer)FertilityConfig.outOfSeasonCropBehavior.get() == 2) {
                if (!plant.m_204336_(ModTags.Blocks.UNBREAKABLE_INFERTILE_CROPS)) {
                    event.setCanceled(true);
                    event.getWorld().m_46961_(event.getPos(), false);
                } else {
                    event.setCanceled(true);
                }
            }
        }
    }

    private boolean isGlassAboveBlock(Level world, BlockPos cropPos) {
        for (int i = 0; i < 16; ++i) {
            if (!world.m_8055_(cropPos.m_142082_(0, i + 1, 0)).m_204336_(ModTags.Blocks.GREENHOUSE_GLASS)) continue;
            return true;
        }
        return false;
    }
}

