/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.api.events.server;

import io.github.kosmx.emotes.api.Pair;
import io.github.kosmx.emotes.common.emote.EmoteData;
import io.github.kosmx.emotes.common.tools.UUIDMap;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public abstract class ServerEmoteAPI {
    protected static ServerEmoteAPI INSTANCE;

    public static void setPlayerPlayingEmote(UUID player, @Nullable EmoteData emote) {
        INSTANCE.setPlayerPlayingEmoteImpl(player, emote, false);
    }

    public static void forcePlayEmote(UUID player, @Nullable EmoteData emote) {
        INSTANCE.setPlayerPlayingEmoteImpl(player, emote, true);
    }

    @Nullable
    public static Pair<EmoteData, Integer> getPlayedEmote(UUID player) {
        return INSTANCE.getPlayedEmoteImpl(player);
    }

    public static HashMap<UUID, EmoteData> getLoadedEmotes() {
        return INSTANCE.getLoadedEmotesImpl();
    }

    public static UUIDMap<EmoteData> getHiddenEmotes() {
        return INSTANCE.getHiddenEmotesImpl();
    }

    public static List<EmoteData> unserializeEmote(InputStream inputStream, @Nullable String quarkName, String format) {
        return INSTANCE.unserializeEmoteImpl(inputStream, quarkName, format);
    }

    @Nullable
    public static EmoteData getEmote(UUID emoteID) {
        return INSTANCE.getEmoteImpl(emoteID);
    }

    protected abstract void setPlayerPlayingEmoteImpl(UUID var1, @Nullable EmoteData var2, boolean var3);

    protected abstract Pair<EmoteData, Integer> getPlayedEmoteImpl(UUID var1);

    protected abstract HashMap<UUID, EmoteData> getLoadedEmotesImpl();

    protected abstract UUIDMap<EmoteData> getHiddenEmotesImpl();

    protected abstract List<EmoteData> unserializeEmoteImpl(InputStream var1, @Nullable String var2, String var3);

    protected abstract EmoteData getEmoteImpl(UUID var1);
}

