/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.emotePlay;

import io.github.kosmx.emotes.common.emote.EmoteData;
import io.github.kosmx.emotes.common.opennbs.SoundPlayer;
import io.github.kosmx.emotes.common.opennbs.format.Layer;
import io.github.kosmx.emotes.executor.emotePlayer.IEmotePlayer;
import io.github.kosmx.playerAnim.layered.EmoteDataPlayer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class EmotePlayer<T>
extends EmoteDataPlayer
implements IEmotePlayer {
    @Nullable
    final SoundPlayer song;

    public EmotePlayer(EmoteData emote, Consumer<Layer.Note> noteConsumer, int t) {
        super(emote, t);
        this.song = emote.song != null ? new SoundPlayer(emote.song, noteConsumer, 0) : null;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isActive() && SoundPlayer.isPlayingSong(this.song)) {
            this.song.tick();
        }
    }

    public static boolean isRunningEmote(@Nullable EmotePlayer emote) {
        return emote != null && emote.isActive();
    }

    @Override
    public boolean isRunning() {
        return this.isActive();
    }
}

