/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.screen.widget;

import io.github.kosmx.emotes.common.tools.MathHelper;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.executor.dataTypes.IIdentifier;
import io.github.kosmx.emotes.executor.dataTypes.Text;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.main.screen.widget.IChooseWheel;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class LegacyChooseWidget<MATRIX, WIDGET>
implements IChooseWheel<MATRIX> {
    protected final ArrayList<FastChooseElement> elements = new ArrayList();
    private boolean hovered;
    private final IIdentifier TEXTURE;
    private final AbstractFastChooseWidget<MATRIX, WIDGET> widget;

    public LegacyChooseWidget(AbstractFastChooseWidget<MATRIX, WIDGET> widget) {
        this.TEXTURE = (Boolean)((ClientConfig)EmoteInstance.config).dark.get() != false ? EmoteInstance.instance.getDefaults().newIdentifier("textures/gui/fastchoose_dark.png") : EmoteInstance.instance.getDefaults().newIdentifier("textures/gui/fastchoose_light.png");
        this.widget = widget;
        this.elements.add(new FastChooseElement(0, 22.5f));
        this.elements.add(new FastChooseElement(1, 67.5f));
        this.elements.add(new FastChooseElement(2, 157.5f));
        this.elements.add(new FastChooseElement(3, 112.5f));
        this.elements.add(new FastChooseElement(4, 337.5f));
        this.elements.add(new FastChooseElement(5, 292.5f));
        this.elements.add(new FastChooseElement(6, 202.5f));
        this.elements.add(new FastChooseElement(7, 247.5f));
    }

    public void drawCenteredText(MATRIX matrixStack, Text stringRenderable, float deg) {
        this.drawCenteredText(matrixStack, stringRenderable, (float)((double)(this.widget.x + this.widget.size / 2) + (double)this.widget.size * 0.4 * Math.sin((double)deg * 0.0174533)), (float)((double)(this.widget.y + this.widget.size / 2) + (double)this.widget.size * 0.4 * Math.cos((double)deg * 0.0174533)));
    }

    public void drawCenteredText(MATRIX matrices, Text stringRenderable, float x, float y) {
        int c = (Boolean)((ClientConfig)EmoteInstance.config).dark.get() != false ? 255 : 0;
        this.widget.textDraw(matrices, stringRenderable, x - (float)this.widget.textRendererGetWidth(stringRenderable) / 2.0f, y - 2.0f, MathHelper.colorHelper(c, c, c, 1));
    }

    @Nullable
    protected FastChooseElement getActivePart(int mouseX, int mouseY) {
        int x = mouseX - this.widget.x - this.widget.size / 2;
        int y = mouseY - this.widget.y - this.widget.size / 2;
        int i = 0;
        if (x == 0) {
            return null;
        }
        if (x < 0) {
            i += 4;
        }
        if (y == 0) {
            return null;
        }
        if (y < 0) {
            i += 2;
        }
        if (Math.abs(x) == Math.abs(y)) {
            return null;
        }
        if (Math.abs(x) > Math.abs(y)) {
            ++i;
        }
        return this.elements.get(i);
    }

    @Override
    public void render(MATRIX matrices, int mouseX, int mouseY, float delta) {
        FastChooseElement part;
        this.checkHovered(mouseX, mouseY);
        this.widget.renderBindTexture(this.TEXTURE);
        this.widget.renderSystemBlendColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.widget.renderEnableBend();
        this.widget.renderDefaultBendFunction();
        this.widget.renderEnableDepthText();
        this.drawTexture(matrices, 0, 0, 0, 0, 2);
        if (this.hovered && (part = this.getActivePart(mouseX, mouseY)) != null && this.widget.doHoverPart(part)) {
            part.renderHover(matrices);
        }
        for (FastChooseElement f : this.elements) {
            if (!f.hasEmote()) continue;
            f.render(matrices);
        }
    }

    private void drawTexture(MATRIX matrices, int x, int y, int u, int v, int s) {
        this.widget.drawableDrawTexture(matrices, this.widget.x + x * this.widget.size / 256, this.widget.y + y * this.widget.size / 256, s * this.widget.size / 2, s * this.widget.size / 2, u, v, s * 128, s * 128, 512, 512);
    }

    private void checkHovered(int mouseX, int mouseY) {
        this.hovered = mouseX >= this.widget.x && mouseY >= this.widget.y && mouseX <= this.widget.x + this.widget.size && mouseY <= this.widget.y + this.widget.size;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        FastChooseElement element;
        this.checkHovered((int)mouseX, (int)mouseY);
        if (this.hovered && this.widget.isValidClickButton(button) && (element = this.getActivePart((int)mouseX, (int)mouseY)) != null) {
            return this.widget.EmotesOnClick(element, button);
        }
        return false;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        this.checkHovered((int)mouseX, (int)mouseY);
        return this.hovered;
    }

    protected class FastChooseElement
    implements IChooseWheel.IChooseElement {
        private final float angle;
        private final int id;

        protected FastChooseElement(int num, float angle) {
            this.angle = angle;
            this.id = num;
        }

        @Override
        public boolean hasEmote() {
            return ((ClientConfig)EmoteInstance.config).fastMenuEmotes[this.id] != null;
        }

        @Override
        public void setEmote(@Nullable EmoteHolder emote) {
            ((ClientConfig)EmoteInstance.config).fastMenuEmotes[this.id] = emote == null ? null : emote.getUuid();
        }

        @Override
        @Nullable
        public EmoteHolder getEmote() {
            UUID uuid = ((ClientConfig)EmoteInstance.config).fastMenuEmotes[this.id];
            if (uuid != null) {
                EmoteHolder emote = (EmoteHolder)EmoteHolder.list.get(uuid);
                if (emote == null && LegacyChooseWidget.this.widget.doesShowInvalid()) {
                    emote = new EmoteHolder.Empty(uuid);
                }
                return emote;
            }
            return null;
        }

        @Override
        public void clearEmote() {
            this.setEmote(null);
        }

        public void render(MATRIX matrices) {
            IIdentifier identifier;
            UUID emoteID = ((ClientConfig)EmoteInstance.config).fastMenuEmotes[this.id] != null ? ((ClientConfig)EmoteInstance.config).fastMenuEmotes[this.id] : null;
            IIdentifier iIdentifier = identifier = emoteID != null && EmoteHolder.list.get(emoteID) != null ? ((EmoteHolder)EmoteHolder.list.get(emoteID)).getIconIdentifier() : null;
            if (identifier != null && ((ClientConfig)EmoteInstance.config).showIcons.get().booleanValue()) {
                int s = ((LegacyChooseWidget)LegacyChooseWidget.this).widget.size / 10;
                int iconX = (int)((double)(((LegacyChooseWidget)LegacyChooseWidget.this).widget.x + ((LegacyChooseWidget)LegacyChooseWidget.this).widget.size / 2) + (double)((LegacyChooseWidget)LegacyChooseWidget.this).widget.size * 0.4 * Math.sin((double)this.angle * 0.0174533)) - s;
                int iconY = (int)((double)(((LegacyChooseWidget)LegacyChooseWidget.this).widget.y + ((LegacyChooseWidget)LegacyChooseWidget.this).widget.size / 2) + (double)((LegacyChooseWidget)LegacyChooseWidget.this).widget.size * 0.4 * Math.cos((double)this.angle * 0.0174533)) - s;
                LegacyChooseWidget.this.widget.renderBindTexture(identifier);
                LegacyChooseWidget.this.widget.drawableDrawTexture(matrices, iconX, iconY, s * 2, s * 2, 0.0f, 0.0f, 256, 256, 256, 256);
            } else if (((ClientConfig)EmoteInstance.config).fastMenuEmotes[this.id] != null) {
                LegacyChooseWidget.this.drawCenteredText(matrices, EmoteHolder.getNonNull((UUID)((ClientConfig)EmoteInstance.config).fastMenuEmotes[this.id]).name, this.angle);
            } else {
                EmoteInstance.instance.getLogger().log(Level.WARNING, "Tried to render non-existing name", true);
            }
        }

        public void renderHover(MATRIX matrices) {
            int textX = 0;
            int textY = 0;
            int x = 0;
            int y = 0;
            if ((this.id & 1) == 0) {
                textY = 256;
            } else {
                textX = 256;
            }
            if ((this.id & 2) == 0) {
                y = 128;
            }
            if ((this.id & 4) == 0) {
                x = 128;
            }
            LegacyChooseWidget.this.drawTexture(matrices, x, y, textX + x, textY + y, 1);
        }
    }
}

