/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.network;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import io.github.kosmx.emotes.api.Pair;
import io.github.kosmx.emotes.api.events.impl.EventResult;
import io.github.kosmx.emotes.api.events.server.ServerEmoteAPI;
import io.github.kosmx.emotes.api.events.server.ServerEmoteEvents;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.emote.EmoteData;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.GeyserEmotePacket;
import io.github.kosmx.emotes.common.network.PacketTask;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.common.tools.BiMap;
import io.github.kosmx.emotes.common.tools.UUIDMap;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.server.config.Serializer;
import io.github.kosmx.emotes.server.geyser.EmoteMappings;
import io.github.kosmx.emotes.server.network.IServerNetworkInstance;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;

public abstract class AbstractServerEmotePlay<P>
extends ServerEmoteAPI {
    protected EmoteMappings bedrockEmoteMap = new EmoteMappings(new BiMap<UUID, UUID>());

    public AbstractServerEmotePlay() {
        try {
            this.initMappings(EmoteInstance.instance.getGameDirectory().resolve("config"));
            ServerEmoteAPI.INSTANCE = this;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initMappings(Path configPath) throws IOException {
        Path filePath = configPath.resolve("emotecraft_emote_map.json");
        if (filePath.toFile().isFile()) {
            BufferedReader reader = Files.newBufferedReader(filePath);
            try {
                this.bedrockEmoteMap = new EmoteMappings((BiMap)Serializer.serializer.fromJson((Reader)reader, new TypeToken<BiMap<UUID, UUID>>(){}.getType()));
            }
            catch (JsonParseException e) {
                e.printStackTrace();
            }
            reader.close();
        } else {
            BiMap<UUID, UUID> example = new BiMap<UUID, UUID>();
            example.put(new UUID(4822678189205111L, -8603657889541918977L), new UUID(-4822678189205112L, 8603657889541918976L));
            BufferedWriter writer = Files.newBufferedWriter(filePath, new OpenOption[0]);
            Serializer.serializer.toJson(example, new TypeToken<BiMap<UUID, UUID>>(){}.getType(), (Appendable)writer);
            writer.close();
        }
    }

    protected boolean doValidate() {
        return (Boolean)EmoteInstance.config.validateEmote.get();
    }

    protected abstract UUID getUUIDFromPlayer(P var1);

    protected abstract P getPlayerFromUUID(UUID var1);

    protected abstract long getRuntimePlayerID(P var1);

    protected abstract IServerNetworkInstance getPlayerNetworkInstance(P var1);

    protected IServerNetworkInstance getPlayerNetworkInstance(UUID player) {
        return this.getPlayerNetworkInstance(this.getPlayerFromUUID(player));
    }

    public void receiveMessage(byte[] bytes, P player, INetworkInstance instance) throws IOException {
        this.receiveMessage(new EmotePacket.Builder().setThreshold(((Float)EmoteInstance.config.validThreshold.get()).floatValue()).build().read(ByteBuffer.wrap(bytes)), player, instance);
    }

    public void receiveMessage(NetData data, P player, INetworkInstance instance) throws IOException {
        EmoteInstance.instance.getLogger().log(Level.FINEST, "[emotes server] Received data from: " + this.getUUIDFromPlayer(player) + " data: " + data);
        switch (data.purpose) {
            case STOP: {
                this.stopEmote(player, data);
                break;
            }
            case CONFIG: {
                instance.setVersions(data.versions);
                instance.presenceResponse();
                break;
            }
            case STREAM: {
                this.handleStreamEmote(data, player, instance);
                break;
            }
            default: {
                throw new IOException("Unknown packet task");
            }
        }
    }

    public void receiveBEEmote(P player, GeyserEmotePacket emotePacket) throws IOException {
        UUID javaEmote = this.bedrockEmoteMap.getJavaEmote(emotePacket.getEmoteID());
        if (javaEmote != null && UniversalEmoteSerializer.getEmote(javaEmote) != null) {
            NetData data = new NetData();
            data.emoteData = UniversalEmoteSerializer.getEmote(javaEmote);
            data.purpose = PacketTask.STREAM;
            this.handleStreamEmote(data, player, null);
        } else {
            this.sendForEveryoneElse(emotePacket, player);
        }
    }

    protected void handleStreamEmote(NetData data, P player, INetworkInstance instance) throws IOException {
        EventResult result;
        if (!data.valid && this.doValidate() && (result = ServerEmoteEvents.EMOTE_VERIFICATION.invoker().verify(data.emoteData, this.getUUIDFromPlayer(player))) != EventResult.FAIL) {
            EmotePacket.Builder stopMSG = new EmotePacket.Builder().configureToSendStop(data.emoteData.getUuid()).configureTarget(this.getUUIDFromPlayer(player)).setSizeLimit(0x100000);
            if (instance != null) {
                instance.sendMessage(stopMSG, null);
            }
            return;
        }
        if (data.player != null) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, "Player: " + player + " does not respect server-side emote tracking. Ignoring repeat", true);
            return;
        }
        if (this.getPlayerNetworkInstance(player).getEmoteTracker().isForced()) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, "Player: " + player + " is disobeying force play flag and tried to override it");
        }
        this.streamEmote(data, player, false);
    }

    protected void streamEmote(NetData data, P player, boolean isForced) {
        this.getPlayerNetworkInstance(player).getEmoteTracker().setPlayedEmote(data.emoteData, isForced);
        ServerEmoteEvents.EMOTE_PLAY.invoker().onEmotePlay(data.emoteData, this.getUUIDFromPlayer(player));
        data.isForced = isForced;
        data.player = this.getUUIDFromPlayer(player);
        UUID bedrockEmoteID = this.bedrockEmoteMap.getBeEmote(data.emoteData.getUuid());
        GeyserEmotePacket geyserEmotePacket = null;
        if (bedrockEmoteID != null) {
            geyserEmotePacket = new GeyserEmotePacket();
            geyserEmotePacket.setEmoteID(bedrockEmoteID);
            geyserEmotePacket.setRuntimeEntityID(this.getRuntimePlayerID(player));
        }
        this.sendForEveryoneElse(data, geyserEmotePacket, player);
    }

    protected void stopEmote(P player, @Nullable NetData originalMessage) {
        Pair<EmoteData, Integer> emote = this.getPlayerNetworkInstance(player).getEmoteTracker().getPlayedEmote();
        this.getPlayerNetworkInstance(player).getEmoteTracker().setPlayedEmote(null, false);
        if (emote != null) {
            ServerEmoteEvents.EMOTE_STOP_BY_USER.invoker().onStopEmote(emote.getLeft().getUuid(), this.getUUIDFromPlayer(player));
            NetData data = new EmotePacket.Builder().configureToSendStop((UUID)emote.getLeft().getUuid(), (UUID)this.getUUIDFromPlayer(player)).build().data;
            this.sendForEveryoneElse(data, null, player);
            if (originalMessage == null) {
                data.isForced = true;
                this.sendForPlayer(data, player, this.getUUIDFromPlayer(player));
            }
        }
    }

    public void playerEntersInvalidPose(P player) {
        if (!this.getPlayerNetworkInstance(player).getEmoteTracker().isForced()) {
            this.stopEmote(player, null);
        }
    }

    public void receiveGeyserMessage(P player, byte[] data) {
        try {
            GeyserEmotePacket packet = new GeyserEmotePacket();
            packet.read(data);
            packet.setRuntimeEntityID(this.getRuntimePlayerID(player));
            this.receiveBEEmote(player, packet);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void playerStartTracking(P tracked, P tracker) {
        if (tracked == null || tracker == null) {
            return;
        }
        Pair<EmoteData, Integer> playedEmote = this.getPlayerNetworkInstance(tracked).getEmoteTracker().getPlayedEmote();
        if (playedEmote != null) {
            this.sendForPlayer(new EmotePacket.Builder().configureToStreamEmote((EmoteData)playedEmote.getLeft()).configureEmoteTick((int)playedEmote.getRight().intValue()).configureTarget((UUID)this.getUUIDFromPlayer(tracked)).build().data, tracked, this.getUUIDFromPlayer(tracker));
        }
    }

    @Override
    protected void setPlayerPlayingEmoteImpl(UUID player, @Nullable EmoteData emoteData, boolean isForced) {
        if (emoteData != null) {
            this.streamEmote(new EmotePacket.Builder().configureToStreamEmote((EmoteData)emoteData).build().data, this.getPlayerFromUUID(player), isForced);
        } else {
            this.stopEmote(this.getPlayerFromUUID(player), null);
        }
    }

    @Override
    protected Pair<EmoteData, Integer> getPlayedEmoteImpl(UUID player) {
        return this.getPlayerNetworkInstance(this.getPlayerFromUUID(player)).getEmoteTracker().getPlayedEmote();
    }

    protected abstract void sendForEveryoneElse(GeyserEmotePacket var1, P var2);

    protected abstract void sendForEveryoneElse(NetData var1, @Nullable GeyserEmotePacket var2, P var3);

    protected abstract void sendForPlayerInRange(NetData var1, P var2, UUID var3);

    protected abstract void sendForPlayer(NetData var1, P var2, UUID var3);

    public static AbstractServerEmotePlay getInstance() {
        return (AbstractServerEmotePlay)ServerEmoteAPI.INSTANCE;
    }

    @Override
    protected HashMap<UUID, EmoteData> getLoadedEmotesImpl() {
        UUIDMap<EmoteData> map = new UUIDMap<EmoteData>();
        map.putAll(UniversalEmoteSerializer.serverEmotes);
        map.putAll(UniversalEmoteSerializer.hiddenServerEmotes);
        return map;
    }

    @Override
    protected UUIDMap<EmoteData> getHiddenEmotesImpl() {
        return UniversalEmoteSerializer.hiddenServerEmotes;
    }

    @Override
    protected List<EmoteData> unserializeEmoteImpl(InputStream inputStream, @Nullable String quarkName, String format) {
        return UniversalEmoteSerializer.readData(inputStream, quarkName, format);
    }

    @Override
    protected EmoteData getEmoteImpl(UUID emoteID) {
        return UniversalEmoteSerializer.getEmote(emoteID);
    }
}

