/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.gauge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.mrscauthd.beyond_earth.gauge.IGaugeValue;
import org.apache.commons.lang3.StringUtils;

public class GaugeTextBuilder {
    private final IGaugeValue value;
    private final String translationKey;
    private final List<Object> extraValues;
    private final Map<Integer, Style> extraStyles;
    private Style textStyle;
    private Style amountStyle;
    private Style capacityStyle;
    private Style unitStyle;
    private String unitSuffix;

    public GaugeTextBuilder(IGaugeValue value, String translationKey, List<Object> extraValues) {
        this.value = value;
        this.translationKey = translationKey;
        this.extraValues = Collections.unmodifiableList(extraValues);
        this.extraStyles = new HashMap<Integer, Style>();
        this.setTextStyle(Style.f_131099_);
        this.setAmountStyle(Style.f_131099_);
        this.setCapacityStyle(Style.f_131099_);
        this.setUnitStyle(Style.f_131099_);
        this.setUnitSuffix("");
    }

    public MutableComponent build() {
        IGaugeValue value = this.getValue();
        Component displayName = value.getDisplayName();
        int amount = value.getAmount();
        int capacity = value.getCapacity();
        String unit = value.getUnit();
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        list.add(this.format(displayName, this.getTextStyle()));
        list.add(this.format(String.valueOf(amount), this.getAmountStyle(), unit, this.getUnitStyle()));
        list.add(this.format(String.valueOf(capacity), this.getCapacityStyle(), unit, this.getUnitStyle()));
        for (int i = 0; i < this.getExtraValues().size(); ++i) {
            Object extraValue = this.getExtraValues().get(i);
            Style extraStyle = this.getExtraStyle(i);
            list.add(new TranslatableComponent("%s", new Object[]{extraValue}).m_6270_(extraStyle));
        }
        return new TranslatableComponent(this.getTranslationKey(), list.toArray()).m_6270_(this.getTextStyle());
    }

    public MutableComponent format(String valueText, Style valueStyle, String unitText, Style unitStyle) {
        if (!StringUtils.isEmpty((CharSequence)unitText)) {
            return this.format(valueText, valueStyle).m_130946_(" ").m_7220_((Component)this.format(unitText + this.getUnitSuffix(), unitStyle));
        }
        return this.format(valueText, valueStyle);
    }

    public MutableComponent format(String text, Style style) {
        return new TextComponent(text).m_6270_(style);
    }

    public MutableComponent format(Component text, Style style) {
        return new TextComponent("").m_7220_(text).m_6270_(style);
    }

    public final IGaugeValue getValue() {
        return this.value;
    }

    public final String getTranslationKey() {
        return this.translationKey;
    }

    public final List<Object> getExtraValues() {
        return this.extraValues;
    }

    public final Map<Integer, Style> getExtraStyles() {
        return this.extraStyles;
    }

    public Style getTextStyle() {
        return this.textStyle;
    }

    public GaugeTextBuilder setTextStyle(Style textStyle) {
        this.textStyle = textStyle;
        return this;
    }

    public Style getAmountStyle() {
        return this.amountStyle;
    }

    public GaugeTextBuilder setAmountStyle(Style amountStyle) {
        this.amountStyle = amountStyle;
        return this;
    }

    public Style getCapacityStyle() {
        return this.capacityStyle;
    }

    public GaugeTextBuilder setCapacityStyle(Style capacityStyle) {
        this.capacityStyle = capacityStyle;
        return this;
    }

    public Style getUnitStyle() {
        return this.unitStyle;
    }

    public GaugeTextBuilder setUnitStyle(Style unitStyle) {
        this.unitStyle = unitStyle;
        return this;
    }

    public String getUnitSuffix() {
        return this.unitSuffix;
    }

    public GaugeTextBuilder setUnitSuffix(String unitSuffix) {
        this.unitSuffix = unitSuffix;
        return this;
    }

    public GaugeTextBuilder setExtraStyle(int index, Style style) {
        this.getExtraStyles().put(index, style);
        return this;
    }

    public Style getExtraStyle(int index) {
        return this.getExtraStyles().getOrDefault(index, Style.f_131099_);
    }
}

