/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.guis.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.crafting.IngredientStack;
import net.mrscauthd.beyond_earth.guis.screens.planetselection.PlanetSelectionGuiWindow;

@OnlyIn(value=Dist.CLIENT)
public class ImageButtonPlacer
extends Button {
    private ResourceLocation buttonTexture;
    private ResourceLocation hoverButtonTexture;
    private boolean rocketCondition;
    private Types type;
    private List<String> list;
    public int row;
    private final int xTexStart;
    private final int yTexStart;
    private final int yDiffText;
    private final int textureWidth;
    private final int textureHeight;

    public ImageButtonPlacer(int xIn, int yIn, int row, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, boolean rocketCondition, Types type, List<String> list, ResourceLocation buttonTexture, ResourceLocation hoverButtonTexture, Button.OnPress onPressIn) {
        this(xIn, yIn, row, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, rocketCondition, type, list, buttonTexture, hoverButtonTexture, 256, 256, onPressIn);
    }

    public ImageButtonPlacer(int xIn, int yIn, int row, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, boolean rocketCondition, Types type, List<String> list, ResourceLocation buttonTexture, ResourceLocation hoverButtonTexture, int p_i51135_9_, int p_i51135_10_, Button.OnPress onPressIn) {
        this(xIn, yIn, row, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, rocketCondition, type, list, buttonTexture, hoverButtonTexture, p_i51135_9_, p_i51135_10_, onPressIn, TextComponent.f_131282_);
    }

    public ImageButtonPlacer(int x, int y, int row, int width, int height, int xTexStart, int yTexStart, int yDiffText, boolean rocketCondition, Types type, List<String> list, ResourceLocation buttonTexture, ResourceLocation hoverButtonTexture, int textureWidth, int textureHeight, Button.OnPress onPress, Component title) {
        this(x, y, row, width, height, xTexStart, yTexStart, yDiffText, rocketCondition, type, list, buttonTexture, hoverButtonTexture, textureWidth, textureHeight, onPress, Button.f_93716_, title);
    }

    public ImageButtonPlacer(int p_i244513_1_, int p_i244513_2_, int row, int p_i244513_3_, int p_i244513_4_, int p_i244513_5_, int p_i244513_6_, int p_i244513_7_, boolean rocketCondition, Types type, List<String> list, ResourceLocation buttonTexture, ResourceLocation hoverButtonTexture, int p_i244513_9_, int p_i244513_10_, Button.OnPress p_i244513_11_, Button.OnTooltip p_i244513_12_, Component p_i244513_13_) {
        super(p_i244513_1_, p_i244513_2_, p_i244513_3_, p_i244513_4_, p_i244513_13_, p_i244513_11_, p_i244513_12_);
        this.row = row;
        this.textureWidth = p_i244513_9_;
        this.textureHeight = p_i244513_10_;
        this.xTexStart = p_i244513_5_;
        this.yTexStart = p_i244513_6_;
        this.yDiffText = p_i244513_7_;
        this.rocketCondition = rocketCondition;
        this.type = type;
        this.list = list;
        this.buttonTexture = buttonTexture;
        this.hoverButtonTexture = hoverButtonTexture;
    }

    public void setPosition(int xIn, int yIn) {
        this.f_93620_ = xIn;
        this.f_93621_ = yIn;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69482_();
        int i = this.yTexStart;
        if (this.m_198029_()) {
            i += this.yDiffText;
        }
        ResourceLocation texture = this.type == Types.SOLAR_SYSTEM_CATEGORY && this.rocketCondition ? this.getTypeTexture(this.f_93622_, PlanetSelectionGuiWindow.GREEN_BUTTON_TEXTURE, PlanetSelectionGuiWindow.GREEN_LIGHT_BUTTON_TEXTURE) : (this.type == Types.PLANET_SPACE_STATION_CATEGORY ? this.getTypeTexture(this.f_93622_, PlanetSelectionGuiWindow.LARGE_GREEN_BUTTON_TEXTURE, PlanetSelectionGuiWindow.LARGE_GREEN_LIGHT_BUTTON_TEXTURE) : this.getTypeTexture(this.f_93622_, this.buttonTexture, this.hoverButtonTexture));
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        ImageButtonPlacer.m_93133_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (float)this.xTexStart, (float)i, (int)this.f_93618_, (int)this.f_93619_, (int)this.textureWidth, (int)this.textureHeight);
        Font fontRenderer = minecraft.f_91062_;
        int j = this.getFGColor();
        GuiComponent.m_93215_((PoseStack)poseStack, (Font)fontRenderer, (Component)this.m_6035_(), (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)(j | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
        if (minecraft.f_91080_ instanceof PlanetSelectionGuiWindow) {
            this.milkyWayCategoryManager(minecraft, poseStack, mouseX, mouseY);
            this.solarSystemCategoryManager(minecraft, poseStack, mouseX, mouseY);
            this.planetCategoryManager(minecraft, poseStack, mouseX, mouseY);
            this.planetSpaceStationCategoryManager(minecraft, poseStack, mouseX, mouseY);
        }
        RenderSystem.m_69465_();
    }

    private void milkyWayCategoryManager(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.f_93622_ && this.type == Types.MILKY_WAY_CATEGORY) {
            Screen screen = minecraft.f_91080_;
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            list.add(new TextComponent("\u00a79" + PlanetSelectionGuiWindow.CATEGORY_TEXT.getString() + ": \u00a7b" + this.list.get(0)));
            list.add(new TextComponent("\u00a79" + PlanetSelectionGuiWindow.TYPE_TEXT.getString() + ": \u00a73" + PlanetSelectionGuiWindow.SOLAR_SYSTEM_TEXT.getString()));
            screen.m_96597_(poseStack, list, mouseX, mouseY);
        }
    }

    private void solarSystemCategoryManager(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.f_93622_ && this.type == Types.SOLAR_SYSTEM_CATEGORY) {
            Screen screen = minecraft.f_91080_;
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            String condition = this.rocketCondition ? "a" : "c";
            list.add(new TextComponent("\u00a79" + PlanetSelectionGuiWindow.CATEGORY_TEXT.getString() + ": \u00a7" + condition + this.list.get(0)));
            list.add(new TextComponent("\u00a79" + PlanetSelectionGuiWindow.PROVIDED_TEXT.getString() + ": \u00a7b" + this.list.get(1)));
            screen.m_96597_(poseStack, list, mouseX, mouseY);
        }
    }

    private void planetCategoryManager(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.f_93622_ && this.type == Types.PLANET_CATEGORY) {
            Screen screen = minecraft.f_91080_;
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            list.add(new TextComponent("\u00a79" + PlanetSelectionGuiWindow.TYPE_TEXT.getString() + ": \u00a73" + this.list.get(0)));
            list.add(new TextComponent("\u00a79" + PlanetSelectionGuiWindow.GRAVITY_TEXT.getString() + ": \u00a73" + this.list.get(1)));
            list.add(new TextComponent("\u00a79" + PlanetSelectionGuiWindow.OXYGEN_TEXT.getString() + ": \u00a7" + this.list.get(2)));
            list.add(new TextComponent("\u00a79" + PlanetSelectionGuiWindow.TEMPERATURE_TEXT.getString() + ": \u00a7" + this.list.get(3)));
            screen.m_96597_(poseStack, list, mouseX, mouseY);
        }
    }

    private void planetSpaceStationCategoryManager(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.f_93622_ && this.type == Types.PLANET_SPACE_STATION_CATEGORY) {
            PlanetSelectionGuiWindow screen = (PlanetSelectionGuiWindow)minecraft.f_91080_;
            ArrayList<TextComponent> list = new ArrayList<TextComponent>();
            list.add(new TextComponent("\u00a79" + PlanetSelectionGuiWindow.ITEM_REQUIREMENT_TEXT.getString()));
            for (IngredientStack ingredientStack : screen.recipe.getIngredientStacks()) {
                boolean check = screen.getSpaceStationItemCheck(ingredientStack);
                Component component = Arrays.stream(ingredientStack.getIngredient().m_43908_()).findFirst().map(ItemStack::m_41786_).orElse(TextComponent.f_131282_);
                list.add(new TextComponent("\u00a78[\u00a76" + ingredientStack.getCount() + "\u00a78]" + (check ? "\u00a7a" : "\u00a7c") + " " + component.getString() + (ingredientStack.getCount() > 1 ? "'s" : "")));
            }
            list.add(new TextComponent("\u00a7c----------------"));
            list.add(new TextComponent("\u00a79" + PlanetSelectionGuiWindow.TYPE_TEXT.getString() + ": \u00a73" + this.list.get(0)));
            list.add(new TextComponent("\u00a79" + PlanetSelectionGuiWindow.GRAVITY_TEXT.getString() + ": \u00a73" + this.list.get(1)));
            list.add(new TextComponent("\u00a79" + PlanetSelectionGuiWindow.OXYGEN_TEXT.getString() + ": \u00a7" + this.list.get(2)));
            list.add(new TextComponent("\u00a79" + PlanetSelectionGuiWindow.TEMPERATURE_TEXT.getString() + ": \u00a7" + this.list.get(3)));
            screen.m_96597_(poseStack, list, mouseX, mouseY);
        }
    }

    private ResourceLocation getTypeTexture(boolean hover, ResourceLocation buttonTexture, ResourceLocation hoverButtonTexture) {
        if (hover) {
            return hoverButtonTexture;
        }
        return buttonTexture;
    }

    public static enum Types {
        MILKY_WAY_CATEGORY,
        SOLAR_SYSTEM_CATEGORY,
        PLANET_CATEGORY,
        PLANET_SPACE_STATION_CATEGORY;

    }
}

