/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.carpetstairsmod;

import com.endlesnights.carpetstairsmod.ExtendedMushroomsCompat;
import com.endlesnights.carpetstairsmod.ICarpetStairsCompat;
import com.endlesnights.carpetstairsmod.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

@Mod(value="carpetstairsmod")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CarpetStairsMod {
    public static final String MODID = "carpetstairsmod";
    public static final String NAME = "Carpet Stairs Mod";
    private static List<Supplier<ICarpetStairsCompat>> compatList = new ArrayList<Supplier<ICarpetStairsCompat>>();
    public static CarpetStairsMod instance;
    public final CreativeModeTab creativeTab;

    public CarpetStairsMod() {
        instance = this;
        this.creativeTab = new CreativeTab();
        compatList.add(ModBlocks::new);
        if (ModList.get().isLoaded("extendedmushrooms")) {
            System.out.println("EXTENDED MUSHROOMS Blocks DETECTED AND LOADED carpetstairsmod COMPAT");
            compatList.add(ExtendedMushroomsCompat::new);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Supplier<ICarpetStairsCompat> compat : compatList) {
            compat.get().registerBlocks(event);
        }
    }

    @SubscribeEvent
    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        for (Supplier<ICarpetStairsCompat> compat : compatList) {
            compat.get().registerPlaceEntries();
        }
    }

    public CreativeModeTab getTab() {
        return this.creativeTab;
    }

    private class CreativeTab
    extends CreativeModeTab {
        public CreativeTab() {
            super(CarpetStairsMod.MODID);
        }

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModBlocks.jungle_wood_floor);
        }
    }
}

