/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.carpetstairsmod.blocks;

import com.endlesnights.carpetstairsmod.blocks.BlockCarpetStair;
import com.endlesnights.carpetstairsmod.blocks.WoodFloorBlock;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WoodFloorStair
extends WoodFloorBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final BooleanProperty CONDITIONAL = BlockStateProperties.f_61428_;
    protected static final VoxelShape TOP_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)0.0, (double)-8.0, (double)0.0, (double)16.0, (double)-7.0, (double)16.0);
    protected static final VoxelShape NWD_CORNER = Block.m_49796_((double)0.0, (double)-8.0, (double)0.0, (double)8.0, (double)-7.0, (double)8.0);
    protected static final VoxelShape SWD_CORNER = Block.m_49796_((double)0.0, (double)-8.0, (double)8.0, (double)8.0, (double)-7.0, (double)16.0);
    protected static final VoxelShape NWU_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)1.0, (double)8.0);
    protected static final VoxelShape SWU_CORNER = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)1.0, (double)16.0);
    protected static final VoxelShape NED_CORNER = Block.m_49796_((double)8.0, (double)-8.0, (double)0.0, (double)16.0, (double)-7.0, (double)8.0);
    protected static final VoxelShape SED_CORNER = Block.m_49796_((double)8.0, (double)-8.0, (double)8.0, (double)16.0, (double)-7.0, (double)16.0);
    protected static final VoxelShape NEU_CORNER = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)8.0);
    protected static final VoxelShape SEU_CORNER = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape[] SLAB_TOP_SHAPES = WoodFloorStair.makeShapes(TOP_SHAPE, NWD_CORNER, NED_CORNER, SWD_CORNER, SED_CORNER);
    protected static final VoxelShape[] SLAB_BOTTOM_SHAPES = WoodFloorStair.makeShapes(BOTTOM_SHAPE, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    private static final int[] field_196522_K = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block parentBlock;

    public WoodFloorStair(Block parentBlock, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)CONDITIONAL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.parentBlock = parentBlock;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE, CONDITIONAL, HALF, WATERLOGGED});
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_60734_() instanceof StairBlock;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.parentBlock.m_5456_());
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (worldIn.m_8055_(currentPos.m_7495_()).m_60734_() instanceof StairBlock && worldIn.m_8055_(currentPos.m_7495_()).m_61143_((Property)StairBlock.f_56842_) == Half.BOTTOM) {
            return (BlockState)((BlockState)((BlockState)stateIn.m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)worldIn.m_8055_(currentPos.m_7495_()).m_61143_((Property)StairBlock.f_56841_)))).m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)worldIn.m_8055_(currentPos.m_7495_()).m_61143_((Property)StairBlock.f_56843_)))).m_61124_((Property)BlockCarpetStair.CONDITIONAL, (Comparable)((Boolean)stateIn.m_61143_((Property)CONDITIONAL)));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private StairsShape getStairsShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return (StairsShape)worldIn.m_8055_(pos.m_7495_()).m_61143_((Property)StairBlock.f_56843_);
    }

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_199780_5_ -> WoodFloorStair.combineShapes(p_199780_5_, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        return voxelshape;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SLAB_BOTTOM_SHAPES[field_196522_K[this.getShapeIndex(state)]];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.m_61143_(SHAPE)).ordinal() * 4 + ((Direction)state.m_61143_((Property)FACING)).m_122416_();
    }
}

