/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.client.generators.lang;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dark_roleplay.marg.common.material.MargMaterial;
import net.dark_roleplay.marg.common.material.MaterialCondition;
import net.dark_roleplay.marg.common.providers.TextProvider;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.server.packs.resources.ResourceManager;

public class LangGenerator {
    private static Pattern regexPattern = Pattern.compile("\\$\\{custom\\}");
    private static Pattern materialRegexPattern = Pattern.compile("\\$\\{material\\}");
    private final MaterialCondition condition;
    private final List<String> customs;
    private final Map<String, String> langKeys;
    public static final Codec<LangGenerator> CODEC = RecordCodecBuilder.create(i -> i.group((App)MaterialCondition.CODEC.fieldOf("material").forGetter(LangGenerator::getCondition), (App)Codec.STRING.listOf().optionalFieldOf("customs", new ArrayList()).forGetter(LangGenerator::getCustoms), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("langEntries", new HashMap()).forGetter(LangGenerator::getLangKeys)).apply((Applicative)i, LangGenerator::new));

    public LangGenerator(MaterialCondition condition, List<String> customs, Map<String, String> langKeys) {
        this.condition = condition;
        this.customs = customs;
        this.langKeys = langKeys;
    }

    public Map<String, String> generate(ResourceManager manager, Set<MargMaterial> materials) {
        HashMap<String, String> langEntries = new HashMap<String, String>();
        for (Map.Entry<String, String> langEntry : this.langKeys.entrySet()) {
            String langValue = I18n.m_118938_((String)langEntry.getValue(), (Object[])new Object[0]);
            if ((materials == null || materials.isEmpty()) && this.customs != null) {
                Matcher keyMatcher = regexPattern.matcher(langEntry.getKey());
                Matcher valueMatcher = regexPattern.matcher(langValue);
                for (String custom : this.customs) {
                    langEntries.put(keyMatcher.replaceAll(custom), valueMatcher.replaceAll(I18n.m_118938_((String)("marg.customs." + custom), (Object[])new Object[0])));
                }
                continue;
            }
            if (materials == null) continue;
            for (MargMaterial material : materials) {
                TextProvider prov = material.getTextProvider();
                String materialName = I18n.m_118938_((String)("marg.material." + material.getMaterialName()), (Object[])new Object[0]);
                String materializedKey = materialRegexPattern.matcher(langEntry.getKey()).replaceAll(material.getMaterialName());
                String materializedValue = materialRegexPattern.matcher(langValue).replaceAll(materialName);
                Matcher keyMatcher = regexPattern.matcher(materializedKey);
                if (keyMatcher.find()) {
                    Matcher valueMatcher = regexPattern.matcher(materializedValue);
                    for (String custom : this.customs) {
                        langEntries.put(keyMatcher.replaceAll(custom), valueMatcher.replaceAll(I18n.m_118938_((String)("marg.customs." + custom), (Object[])new Object[0])));
                    }
                    continue;
                }
                langEntries.put(materializedKey, materializedValue);
            }
        }
        return langEntries;
    }

    public MaterialCondition getCondition() {
        return this.condition;
    }

    public List<String> getCustoms() {
        return this.customs;
    }

    public Map<String, String> getLangKeys() {
        return this.langKeys;
    }
}

