/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.common.generators.text.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.dark_roleplay.marg.common.generators.text.generator.TextGeneratorTask;
import net.dark_roleplay.marg.common.material.MargMaterial;
import net.dark_roleplay.marg.common.material.MaterialCondition;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.fml.LogicalSide;

public class TextGenerator {
    private final int generatorVersion;
    private final MaterialCondition condition;
    private final List<String> customs;
    private final List<TextGeneratorTask> tasks;
    public static final Codec<TextGenerator> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.optionalFieldOf("generatorVersion", (Object)0).forGetter(TextGenerator::getGeneratorVersion), (App)MaterialCondition.CODEC.fieldOf("material").forGetter(TextGenerator::getCondition), (App)Codec.STRING.listOf().optionalFieldOf("customs", new ArrayList()).forGetter(TextGenerator::getCustoms), (App)TextGeneratorTask.CODEC.listOf().fieldOf("tasks").forGetter(TextGenerator::getTasks)).apply((Applicative)i, TextGenerator::new));

    public TextGenerator(int generatorVersion, MaterialCondition condition, List<String> customs, List<TextGeneratorTask> tasks) {
        this.generatorVersion = generatorVersion;
        this.condition = condition;
        this.customs = customs;
        this.tasks = tasks;
    }

    public void setLogicalSide(LogicalSide side) {
        for (TextGeneratorTask task : this.tasks) {
            task.setLogicalSide(side);
        }
    }

    public void generate(ResourceManager manager, Set<MargMaterial> materials) {
        for (TextGeneratorTask task : this.tasks) {
            task.generate(manager, materials, this.customs);
        }
    }

    public int getGeneratorVersion() {
        return this.generatorVersion;
    }

    public MaterialCondition getCondition() {
        return this.condition;
    }

    public List<String> getCustoms() {
        return this.customs;
    }

    public List<TextGeneratorTask> getTasks() {
        return this.tasks;
    }
}

