/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.common.material;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.dark_roleplay.marg.MargClient;
import net.dark_roleplay.marg.MargServer;
import net.dark_roleplay.marg.common.material.MaterialProperties;
import net.dark_roleplay.marg.common.providers.TextProvider;
import net.dark_roleplay.marg.common.providers.TextureProvider;
import net.dark_roleplay.marg.util.DistConsumer;

public class MargMaterial {
    public static final Codec<MargMaterial> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("materialType").forGetter(MargMaterial::getMaterialType), (App)Codec.STRING.fieldOf("name").forGetter(MargMaterial::getMaterialName), (App)Codec.STRING.optionalFieldOf("requiredMod", null).forGetter(MargMaterial::getRequiredMods), (App)MaterialProperties.CODEC.fieldOf("properties").forGetter(MargMaterial::getProperties), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("textures").forGetter(mat -> mat.getTextureProvider().getTextures()), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("items").forGetter(MargMaterial::getItems), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("blocks").forGetter(MargMaterial::getBlocks)).apply((Applicative)i, MargMaterial::new));
    private String materialType;
    private String materialName;
    private String requiredMods;
    private MaterialProperties properties;
    private TextureProvider textureProvider;
    private TextProvider textProvider;
    private Map<String, String> items;
    private Map<String, String> blocks;

    public MargMaterial(String materialType, String materialName, String requiredMods, MaterialProperties properties, Map<String, String> textures, Map<String, String> items, Map<String, String> blocks) {
        this.materialType = materialType;
        this.materialName = materialName;
        this.requiredMods = requiredMods;
        this.properties = properties;
        this.textProvider = new TextProvider(materialName);
        this.textureProvider = (TextureProvider)DistConsumer.safeConsumeForDist(textures, () -> MargClient::createTextureProvider, () -> MargServer::createTextureProvider);
        this.items = items;
        this.blocks = blocks;
        for (Map.Entry<String, String> texture : textures.entrySet()) {
            this.textProvider.addEntry("texture%" + texture.getKey(), texture.getValue());
        }
        for (Map.Entry<String, String> item : items.entrySet()) {
            this.textProvider.addEntry("item%" + item.getKey(), item.getValue());
        }
        for (Map.Entry<String, String> block : blocks.entrySet()) {
            this.textProvider.addEntry("block%" + block.getKey(), block.getValue());
        }
    }

    public String getMaterialType() {
        return this.materialType;
    }

    public String getMaterialName() {
        return this.materialName;
    }

    public String getRequiredMods() {
        return this.requiredMods;
    }

    public TextureProvider getTextureProvider() {
        return this.textureProvider;
    }

    public TextProvider getTextProvider() {
        return this.textProvider;
    }

    public MaterialProperties getProperties() {
        return this.properties;
    }

    public Map<String, String> getItems() {
        return this.items;
    }

    public Map<String, String> getBlocks() {
        return this.blocks;
    }
}

