/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine;

import dev.compactmods.machines.api.core.Tooltips;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.machine.CompactMachineBlock;
import dev.compactmods.machines.room.RoomSize;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CompactMachineItem
extends BlockItem {
    private static final String ROOM_NBT = "room_pos";

    public CompactMachineItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    @Deprecated(forRemoval=true)
    public static Optional<Integer> getMachineId(ItemStack stack) {
        if (!stack.m_41782_()) {
            return Optional.empty();
        }
        CompoundTag machineData = stack.m_41784_();
        if (machineData.m_128441_("machine_id")) {
            int c = machineData.m_128451_("machine_id");
            return c > -1 ? Optional.of(c) : Optional.empty();
        }
        return Optional.empty();
    }

    public static Item getItemBySize(RoomSize size) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case RoomSize.TINY -> (Item)Registration.MACHINE_BLOCK_ITEM_TINY.get();
            case RoomSize.SMALL -> (Item)Registration.MACHINE_BLOCK_ITEM_SMALL.get();
            case RoomSize.NORMAL -> (Item)Registration.MACHINE_BLOCK_ITEM_NORMAL.get();
            case RoomSize.LARGE -> (Item)Registration.MACHINE_BLOCK_ITEM_LARGE.get();
            case RoomSize.GIANT -> (Item)Registration.MACHINE_BLOCK_ITEM_GIANT.get();
            case RoomSize.MAXIMUM -> (Item)Registration.MACHINE_BLOCK_ITEM_MAXIMUM.get();
        };
    }

    public static Optional<ChunkPos> getRoom(ItemStack stack) {
        if (!stack.m_41782_()) {
            return Optional.empty();
        }
        CompoundTag tag = stack.m_41783_();
        if (!tag.m_128441_(ROOM_NBT)) {
            return Optional.empty();
        }
        int[] roomNbt = tag.m_128465_(ROOM_NBT);
        return Optional.of(new ChunkPos(roomNbt[0], roomNbt[1]));
    }

    public static void setRoom(ItemStack stack, ChunkPos room) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128385_(ROOM_NBT, new int[]{room.f_45578_, room.f_45579_});
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                return;
            }
            CompactMachineItem.getRoom(stack).ifPresentOrElse(room -> tooltip.add((Component)TranslationUtil.tooltip(Tooltips.ROOM_NAME, room)), () -> CompactMachineItem.getMachineId(stack).ifPresent(id -> tooltip.add((Component)TranslationUtil.tooltip(Tooltips.Machines.ID, id))));
        }
        if (Screen.m_96638_()) {
            Block b = Block.m_49814_((Item)stack.m_41720_());
            if (b instanceof CompactMachineBlock) {
                CompactMachineBlock cmb = (CompactMachineBlock)b;
                RoomSize size = cmb.getSize();
                int internalSize = size.getInternalSize();
                MutableComponent text = TranslationUtil.tooltip(Tooltips.Machines.SIZE, internalSize).m_130940_(ChatFormatting.YELLOW);
                tooltip.add((Component)text);
            }
        } else {
            MutableComponent text = TranslationUtil.tooltip(Tooltips.HINT_HOLD_SHIFT).m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC);
            tooltip.add((Component)text);
        }
    }
}

