/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.tunnel;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.api.core.Tooltips;
import dev.compactmods.machines.api.room.history.IRoomHistoryItem;
import dev.compactmods.machines.api.tunnels.TunnelDefinition;
import dev.compactmods.machines.api.tunnels.redstone.IRedstoneTunnel;
import dev.compactmods.machines.core.Capabilities;
import dev.compactmods.machines.core.CompactMachinesNet;
import dev.compactmods.machines.core.MissingDimensionException;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.core.Tunnels;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.tunnel.TunnelHelper;
import dev.compactmods.machines.tunnel.TunnelWallBlock;
import dev.compactmods.machines.tunnel.TunnelWallEntity;
import dev.compactmods.machines.tunnel.graph.TunnelConnectionGraph;
import dev.compactmods.machines.tunnel.network.TunnelAddedPacket;
import dev.compactmods.machines.util.PlayerUtil;
import dev.compactmods.machines.wall.SolidWallBlock;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class TunnelItem
extends Item {
    public TunnelItem(Item.Properties properties) {
        super(properties);
    }

    public static void setTunnelType(ItemStack stack, TunnelDefinition definition) {
        CompoundTag defTag = stack.m_41698_("definition");
        defTag.m_128359_("id", definition.getRegistryName().toString());
    }

    @Nonnull
    public static ItemStack createStack(TunnelDefinition definition) {
        ItemStack stack = new ItemStack((ItemLike)Tunnels.ITEM_TUNNEL.get(), 1);
        TunnelItem.setTunnelType(stack, definition);
        return stack;
    }

    public Component m_7626_(ItemStack stack) {
        String key = TunnelItem.getDefinition(stack).map(def -> {
            ResourceLocation id = def.getRegistryName();
            return TranslationUtil.tunnelId(id);
        }).orElse("item.compactmachines.tunnels.unnamed");
        return new TranslatableComponent(key);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        TunnelItem.getDefinition(stack).ifPresent(tunnelDef -> {
            if (Screen.m_96638_()) {
                MutableComponent type = new TranslatableComponent("tooltip.compactmachines.tunnel_type", new Object[]{tunnelDef.getRegistryName()}).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC);
                tooltip.add((Component)type);
            } else {
                tooltip.add((Component)TranslationUtil.tooltip(Tooltips.HINT_HOLD_SHIFT).m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
            }
        });
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            IForgeRegistry definitions = RegistryManager.ACTIVE.getRegistry(TunnelDefinition.class);
            definitions.getValues().forEach(def -> {
                if (def == Tunnels.UNKNOWN.get()) {
                    return;
                }
                ItemStack withDef = new ItemStack((ItemLike)this, 1);
                CompoundTag defTag = withDef.m_41698_("definition");
                defTag.m_128359_("id", def.getRegistryName().toString());
                items.add((Object)withDef);
            });
        }
    }

    public static Optional<TunnelDefinition> getDefinition(ItemStack stack) {
        CompoundTag defTag = stack.m_41698_("definition");
        if (defTag.m_128456_() || !defTag.m_128441_("id")) {
            return Optional.empty();
        }
        ResourceLocation defId = new ResourceLocation(defTag.m_128461_("id"));
        if (!Tunnels.isRegistered(defId)) {
            return Optional.empty();
        }
        TunnelDefinition tunnelReg = Tunnels.getDefinition(defId);
        return Optional.ofNullable(tunnelReg);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ServerLevel sl;
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        BlockPos position = context.m_8083_();
        BlockState state = level.m_8055_(position);
        if (level instanceof ServerLevel && (sl = (ServerLevel)level).m_46472_().equals(Registration.COMPACT_DIMENSION) && state.m_60734_() instanceof SolidWallBlock && player != null) {
            TunnelItem.getDefinition(context.m_43722_()).ifPresent(def -> {
                try {
                    boolean success = TunnelItem.setupTunnelWall(sl, position, context.m_43719_(), player, def);
                    if (success && !player.m_7500_()) {
                        context.m_43722_().m_41774_(1);
                    }
                }
                catch (MissingDimensionException | Exception e) {
                    CompactMachines.LOGGER.error((Object)e);
                }
            });
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public static Optional<IRoomHistoryItem> getMachineBindingInfo(Player player) {
        LazyOptional history = player.getCapability(Capabilities.ROOM_HISTORY);
        IRoomHistoryItem mapped = history.resolve().map(hist -> {
            if (!hist.hasHistory() && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                PlayerUtil.howDidYouGetThere(sp);
                return null;
            }
            return hist.peek();
        }).orElse(null);
        return Optional.ofNullable(mapped);
    }

    private static boolean setupTunnelWall(ServerLevel compactDim, BlockPos position, Direction innerFace, Player player, TunnelDefinition def) throws Exception, MissingDimensionException {
        boolean redstone = def instanceof IRedstoneTunnel;
        TunnelConnectionGraph roomTunnels = TunnelConnectionGraph.forRoom(compactDim, player.m_146902_());
        Optional<IRoomHistoryItem> lastEnteredMachine = TunnelItem.getMachineBindingInfo(player);
        if (lastEnteredMachine.isEmpty()) {
            CompactMachines.LOGGER.warn("Player does not appear to have entered room via a machine; history is empty. If this is an error, report it.");
            return false;
        }
        IRoomHistoryItem hist = lastEnteredMachine.get();
        Set placedSides = roomTunnels.getTunnelSides(def).collect(Collectors.toSet());
        if (placedSides.size() == 6) {
            return false;
        }
        Optional<Direction> newlyPlacedSide = TunnelHelper.getOrderedSides().filter(s -> !placedSides.contains(s)).findFirst();
        if (newlyPlacedSide.isEmpty()) {
            player.m_5661_((Component)TranslationUtil.message(Messages.NO_TUNNEL_SIDE).m_130940_(ChatFormatting.DARK_RED), true);
            return false;
        }
        Direction first = newlyPlacedSide.get();
        BlockState tunnelState = (BlockState)((BlockState)((BlockState)((Block)Tunnels.BLOCK_TUNNEL_WALL.get()).m_49966_().m_61124_((Property)TunnelWallBlock.TUNNEL_SIDE, (Comparable)innerFace)).m_61124_((Property)TunnelWallBlock.CONNECTED_SIDE, (Comparable)first)).m_61124_((Property)TunnelWallBlock.REDSTONE, (Comparable)Boolean.valueOf(redstone));
        boolean connected = roomTunnels.registerTunnel(position, def, hist.getMachine(), first);
        if (!connected) {
            player.m_5661_((Component)TranslationUtil.message(Messages.NO_TUNNEL_SIDE), true);
            return false;
        }
        BlockState oldState = compactDim.m_8055_(position);
        compactDim.m_7731_(position, tunnelState, 1);
        BlockEntity blockEntity = compactDim.m_7702_(position);
        if (blockEntity instanceof TunnelWallEntity) {
            TunnelWallEntity twe = (TunnelWallEntity)blockEntity;
            twe.setTunnelType(def);
            twe.setConnectedTo(hist.getMachine(), first);
            CompactMachinesNet.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> compactDim.m_46745_(position)), (Object)new TunnelAddedPacket(position, def));
        }
        compactDim.m_7260_(position, oldState, tunnelState, 3);
        return true;
    }
}

