/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.compat.sereneseasons;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.config.ServerConfig;
import sereneseasons.season.SeasonHooks;

public class SereneSeasonsCompat {
    public static boolean shouldMelt(Level level, BlockPos pos, Holder<Biome> biome) {
        if (!BiomeConfig.enablesSeasonalEffects(biome)) {
            return false;
        }
        if (!((Boolean)SeasonsConfig.generateSnowAndIce.get()).booleanValue() || !ServerConfig.isDimensionWhitelisted((ResourceKey)level.m_46472_())) {
            return false;
        }
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((Level)level).getSubSeason();
        Season season = subSeason.getSeason();
        if (season == Season.WINTER) {
            return false;
        }
        return level.f_46441_.nextInt((switch (subSeason) {
            case Season.SubSeason.EARLY_SPRING -> 16;
            case Season.SubSeason.MID_SPRING -> 12;
            case Season.SubSeason.LATE_SPRING -> 8;
            default -> 4;
        }) >> 1) == 0 && !SereneSeasonsCompat.coldEnoughToSnow(level, pos, biome);
    }

    public static boolean coldEnoughToSnow(Level level, BlockPos pos, Holder<Biome> biome) {
        return SeasonHooks.getBiomeTemperature((Level)level, biome, (BlockPos)pos) < 0.15f;
    }
}

